/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.initandlookup;

import java.util.List;
import java.util.Locale;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.Table;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.BytemanHelper;
import org.hibernate.search.testsupport.BytemanHelperStateCleanup;
import org.hibernate.search.testsupport.TestForIssue;
import org.jboss.byteman.contrib.bmunit.BMRule;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=BMUnitRunner.class)
public class CriteriaObjectInitializerAndHierarchyInheritanceTest
extends SearchTestBase {
    @Rule
    public BytemanHelperStateCleanup bytemanState = new BytemanHelperStateCleanup();

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{BaseEntity.class, A.class, AA.class, AAA.class, AAB.class, AB.class, ABA.class, AC.class, B.class, BA.class};
    }

    @BMRule(name="trackCriteriaEntityType", targetClass="org.hibernate.search.query.hibernate.impl.CriteriaObjectInitializer", targetMethod="buildUpCriteria(java.util.List, org.hibernate.search.query.hibernate.impl.ObjectInitializationContext)", targetLocation="EXIT", helper="org.hibernate.search.testsupport.BytemanHelper", binding="c : org.hibernate.internal.CriteriaImpl = $!.get(0);", action="pushEvent(c.getEntityOrClassName())")
    @Test
    @TestForIssue(jiraKey="HSEARCH-2301")
    public void testJoinsAreOnlyOnUsefulEntityTypes() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        int i = 1;
        this.createInstance(s, A.class, i++, "A");
        this.createInstance(s, A.class, i++, "A");
        this.createInstance(s, AA.class, i++, "A AA");
        this.createInstance(s, AA.class, i++, "A AA");
        this.createInstance(s, AAA.class, i++, "A AA AAA");
        this.createInstance(s, AAA.class, i++, "A AA AAA");
        this.createInstance(s, AAA.class, i++, "A AA AAA");
        this.createInstance(s, AAB.class, i++, "A AA AAB");
        this.createInstance(s, AAB.class, i++, "A AA AAB");
        this.createInstance(s, AB.class, i++, "A AB");
        this.createInstance(s, AB.class, i++, "A AB");
        this.createInstance(s, ABA.class, i++, "A AB ABA");
        this.createInstance(s, ABA.class, i++, "A AB ABA");
        this.createInstance(s, AC.class, i++, "A AC");
        this.createInstance(s, AC.class, i++, "A AC");
        this.createInstance(s, B.class, i++, "B");
        this.createInstance(s, B.class, i++, "B");
        this.createInstance(s, BA.class, i++, "B BA");
        this.createInstance(s, BA.class, i++, "B BA");
        tx.commit();
        s.clear();
        FullTextSession session = Search.getFullTextSession((Session)s);
        List<?> results = this.getResults(session, AAA.class);
        Assertions.assertThat(results).onProperty("name").containsOnly(new Object[]{"A AA AAA"});
        Assertions.assertThat((String)BytemanHelper.consumeNextRecordedEvent()).isEqualTo((Object)AAA.class.getName());
        results = this.getResults(session, AAA.class, AAB.class);
        Assertions.assertThat(results).onProperty("name").containsOnly(new Object[]{"A AA AAA", "A AA AAB"});
        Assertions.assertThat((String)BytemanHelper.consumeNextRecordedEvent()).isEqualTo((Object)AA.class.getName());
        results = this.getResults(session, AAA.class, AB.class);
        Assertions.assertThat(results).onProperty("name").containsOnly(new Object[]{"A AA AAA", "A AB", "A AB ABA"});
        Assertions.assertThat((String)BytemanHelper.consumeNextRecordedEvent()).isEqualTo((Object)A.class.getName());
        results = this.getResults(session, AAA.class, BA.class);
        Assertions.assertThat(results).onProperty("name").containsOnly(new Object[]{"A AA AAA", "B BA"});
        Assertions.assertThat((String)BytemanHelper.consumeNextRecordedEvent()).isIn(new Object[]{AAA.class.getName(), BA.class.getName()});
        results = this.getResultsFiltered(session, (Query)new MatchAllDocsQuery(), A.class);
        Assertions.assertThat((String)BytemanHelper.consumeNextRecordedEvent()).isEqualTo((Object)A.class.getName());
        TermQuery termQueryAAA = new TermQuery(new Term("name", "aaa"));
        results = this.getResultsFiltered(session, (Query)termQueryAAA, A.class);
        Assertions.assertThat((String)BytemanHelper.consumeNextRecordedEvent()).isEqualTo((Object)AAA.class.getName());
        BooleanQuery.Builder bqb = new BooleanQuery.Builder();
        TermQuery termQueryAAB = new TermQuery(new Term("name", "aab"));
        bqb.add((Query)termQueryAAA, BooleanClause.Occur.SHOULD);
        bqb.add((Query)termQueryAAB, BooleanClause.Occur.SHOULD);
        results = this.getResultsFiltered(session, (Query)bqb.build(), A.class);
        Assertions.assertThat((String)BytemanHelper.consumeNextRecordedEvent()).isEqualTo((Object)AA.class.getName());
        s.close();
    }

    private void createInstance(Session s, Class<? extends BaseEntity> clazz, Integer id, String name) throws Exception {
        BaseEntity entity = clazz.newInstance();
        entity.id = id;
        entity.name = name;
        s.persist((Object)entity);
    }

    private List<?> getResults(FullTextSession session, Class<? extends BaseEntity> ... classes) {
        BooleanQuery.Builder bqb = new BooleanQuery.Builder();
        for (Class<? extends BaseEntity> clazz : classes) {
            bqb.add((Query)new TermQuery(new Term("name", clazz.getSimpleName().toLowerCase(Locale.ENGLISH))), BooleanClause.Occur.SHOULD);
        }
        return this.getResultsFiltered(session, (Query)bqb.build(), BaseEntity.class);
    }

    private List<?> getResultsFiltered(FullTextSession session, Query query, Class<? extends BaseEntity> ... classes) {
        return session.createFullTextQuery(query, (Class[])classes).setSort(new Sort(new SortField("idSort", SortField.Type.INT))).list();
    }

    @Entity
    @Indexed
    @Table(name="BA")
    public static class BA
    extends B {
    }

    @Entity
    @Indexed
    @Table(name="B")
    public static class B
    extends BaseEntity {
    }

    @Entity
    @Indexed
    @Table(name="AC")
    public static class AC
    extends A {
    }

    @Entity
    @Indexed
    @Table(name="ABA")
    public static class ABA
    extends AB {
    }

    @Entity
    @Indexed
    @Table(name="AB")
    public static class AB
    extends A {
    }

    @Entity
    @Indexed
    @Table(name="AAB")
    public static class AAB
    extends AA {
    }

    @Entity
    @Indexed
    @Table(name="AAA")
    public static class AAA
    extends AA {
    }

    @Entity
    @Indexed
    @Table(name="AA")
    public static class AA
    extends A {
    }

    @Entity
    @Indexed
    @Table(name="A")
    public static class A
    extends BaseEntity {
    }

    @MappedSuperclass
    @Inheritance(strategy=InheritanceType.JOINED)
    @Table(name="BaseEntity")
    public static abstract class BaseEntity {
        @Id
        @DocumentId
        @Field(name="idSort")
        @SortableField(forField="idSort")
        Integer id;
        @Field
        String name;

        public String getName() {
            return this.name;
        }
    }
}

