/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.TouristAttraction;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class LuceneNumericFieldTest
extends SearchTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.prepareData();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.cleanData();
        super.tearDown();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1987")
    public void testOneOfSeveralFieldsIsNumeric() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            QueryContextBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder();
            Query query = queryBuilder.forEntity(TouristAttraction.class).get().all().createQuery();
            List list = fullTextSession.createFullTextQuery(query, new Class[]{TouristAttraction.class}).setProjection(new String[]{"__HSearch_Document"}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Document document = (Document)((Object[])list.iterator().next())[0];
            IndexableField scoreNumeric = document.getField("scoreNumeric");
            Assertions.assertThat((Object)scoreNumeric.numericValue()).isEqualTo((Object)23);
            IndexableField scoreString = document.getField("scoreString");
            Assertions.assertThat((Object)scoreString.numericValue()).isNull();
            Assertions.assertThat((String)scoreString.stringValue()).isEqualTo((Object)"23");
            tx.commit();
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1987")
    public void testNumericMappingOfEmbeddedFields() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            QueryContextBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder();
            Query query = queryBuilder.forEntity(ScoreBoard.class).get().all().createQuery();
            List list = fullTextSession.createFullTextQuery(query, new Class[]{ScoreBoard.class}).setProjection(new String[]{"__HSearch_Document"}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Document document = (Document)((Object[])list.iterator().next())[0];
            IndexableField scoreNumeric = document.getField("score_id");
            Assertions.assertThat((Object)scoreNumeric.numericValue()).isEqualTo((Object)1);
            IndexableField beta = document.getField("score_beta");
            Assertions.assertThat((Object)beta.numericValue()).isEqualTo((Object)100);
            tx.commit();
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{TouristAttraction.class, ScoreBoard.class, Score.class};
    }

    private void prepareData() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            TouristAttraction attraction = new TouristAttraction(1, 23, 46);
            fullTextSession.save((Object)attraction);
            Score score1 = new Score();
            score1.id = 1;
            score1.subscore = 100;
            fullTextSession.save((Object)score1);
            ScoreBoard scoreboard = new ScoreBoard();
            scoreboard.id = 1L;
            scoreboard.scores.add(score1);
            fullTextSession.save((Object)scoreboard);
            tx.commit();
        }
    }

    private void cleanData() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Transaction tx = fullTextSession.beginTransaction();
            List attractions = fullTextSession.createCriteria(TouristAttraction.class).list();
            for (Object attraction : attractions) {
                fullTextSession.delete(attraction);
            }
            List scoreboards = fullTextSession.createCriteria(ScoreBoard.class).list();
            for (ScoreBoard scoreboard : scoreboards) {
                fullTextSession.delete((Object)scoreboard);
            }
            List scores = fullTextSession.createCriteria(Score.class).list();
            for (Score score : scores) {
                fullTextSession.delete((Object)score);
            }
            tx.commit();
        }
    }

    @Indexed
    @Entity
    static class Score {
        @Id
        @NumericField
        Integer id;
        @Field(name="beta", store=Store.YES)
        Integer subscore;

        Score() {
        }
    }

    @Indexed
    @Entity
    static class ScoreBoard {
        @Id
        Long id;
        @IndexedEmbedded(includeEmbeddedObjectId=true, prefix="score_")
        @OneToMany
        Set<Score> scores = new HashSet<Score>();

        ScoreBoard() {
        }
    }
}

