/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.id;

import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.Search;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.id.PersonPK;
import org.hibernate.search.test.id.PersonPKBridge;
import org.hibernate.search.test.id.PlainPerson;
import org.junit.Assert;
import org.junit.Test;

public class ProgrammaticEmbeddedItTest
extends SearchTestBase {
    @Test
    public void testFieldBridge() throws Exception {
        PersonPK emmanuelPk = new PersonPK();
        emmanuelPk.setFirstName("Emmanuel");
        emmanuelPk.setLastName("Bernard");
        PlainPerson emmanuel = new PlainPerson();
        emmanuel.setFavoriteColor("Blue");
        emmanuel.setId(emmanuelPk);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.save((Object)emmanuel);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        List results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)new TermQuery(new Term("id_content.lastName", "Bernard")), new Class[0]).list();
        Assert.assertEquals((long)1L, (long)results.size());
        emmanuel = (PlainPerson)results.get(0);
        emmanuel.setFavoriteColor("Red");
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)new TermQuery(new Term("id_content.lastName", "Bernard")), new Class[0]).list();
        Assert.assertEquals((long)1L, (long)results.size());
        emmanuel = (PlainPerson)results.get(0);
        Assert.assertEquals((Object)"Red", (Object)emmanuel.getFavoriteColor());
        s.delete(results.get(0));
        tx.commit();
        s.close();
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(PlainPerson.class).indexed().property("id", ElementType.FIELD).documentId().bridge(PersonPKBridge.class).property("", ElementType.FIELD).field();
        cfg.put("hibernate.search.model_mapping", mapping);
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{PlainPerson.class};
    }
}

