/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.cfg.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.impl.DelegatingClassLoaderService;
import org.hibernate.search.cfg.impl.DelegatingNamedResolver;
import org.hibernate.search.cfg.impl.HibernateCoreIdUniquenessResolver;
import org.hibernate.search.cfg.spi.IdUniquenessResolver;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.cfg.spi.SearchConfigurationBase;
import org.hibernate.search.engine.impl.HibernateStatelessInitializer;
import org.hibernate.search.engine.service.named.spi.NamedResolver;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.hcore.impl.HibernateSessionFactoryService;
import org.hibernate.search.spi.InstanceInitializer;

public class SearchConfigurationFromHibernateCore
extends SearchConfigurationBase
implements SearchConfiguration {
    private final ConfigurationService configurationService;
    private final org.hibernate.search.engine.service.classloading.spi.ClassLoaderService classLoaderService;
    private final Map<Class<? extends Service>, Object> providedServices;
    private final Metadata metadata;
    private final Properties legacyConfigurationProperties;
    private final boolean multitenancyEnabled;
    private ReflectionManager reflectionManager;

    public SearchConfigurationFromHibernateCore(Metadata metadata, ConfigurationService configurationService, ClassLoaderService hibernateClassLoaderService, HibernateSessionFactoryService sessionService, JndiService namingService) {
        this.metadata = metadata;
        if (configurationService == null) {
            throw new NullPointerException("Configuration is null");
        }
        this.configurationService = configurationService;
        if (hibernateClassLoaderService == null) {
            throw new NullPointerException("ClassLoaderService is null");
        }
        this.classLoaderService = new DelegatingClassLoaderService(hibernateClassLoaderService);
        HashMap<Class<NamedResolver>, Object> providedServices = new HashMap<Class<NamedResolver>, Object>(1);
        providedServices.put(IdUniquenessResolver.class, new HibernateCoreIdUniquenessResolver(metadata));
        providedServices.put(HibernateSessionFactoryService.class, sessionService);
        providedServices.put(NamedResolver.class, new DelegatingNamedResolver(namingService));
        this.providedServices = Collections.unmodifiableMap(providedServices);
        this.legacyConfigurationProperties = SearchConfigurationFromHibernateCore.extractProperties(configurationService);
        MultiTenancyStrategy multitenancyStrategy = sessionService.getSessionFactory().getSessionFactoryOptions().getMultiTenancyStrategy();
        this.multitenancyEnabled = !MultiTenancyStrategy.NONE.equals((Object)multitenancyStrategy);
    }

    public Iterator<Class<?>> getClassMappings() {
        return new ClassIterator(this.metadata.getEntityBindings().iterator());
    }

    public Class<?> getClassMapping(String entityName) {
        return this.metadata.getEntityBinding(entityName).getMappedClass();
    }

    public String getProperty(String propertyName) {
        return (String)this.configurationService.getSetting(propertyName, StandardConverters.STRING);
    }

    public Properties getProperties() {
        return this.legacyConfigurationProperties;
    }

    public ReflectionManager getReflectionManager() {
        if (this.reflectionManager == null) {
            if (this.metadata instanceof MetadataImplementor) {
                this.reflectionManager = ((MetadataImplementor)this.metadata).getMetadataBuildingOptions().getReflectionManager();
            }
            if (this.reflectionManager == null) {
                this.reflectionManager = new JavaReflectionManager();
            }
        }
        return this.reflectionManager;
    }

    public SearchMapping getProgrammaticMapping() {
        return null;
    }

    public Map<Class<? extends Service>, Object> getProvidedServices() {
        return this.providedServices;
    }

    public InstanceInitializer getInstanceInitializer() {
        return HibernateStatelessInitializer.INSTANCE;
    }

    public boolean isIndexMetadataComplete() {
        return true;
    }

    public boolean isMultitenancyEnabled() {
        return this.multitenancyEnabled;
    }

    public org.hibernate.search.engine.service.classloading.spi.ClassLoaderService getClassLoaderService() {
        return this.classLoaderService;
    }

    private static Properties extractProperties(ConfigurationService configurationService) {
        Properties props = new Properties();
        Set entrySet = configurationService.getSettings().entrySet();
        for (Map.Entry entry : entrySet) {
            Object key = entry.getKey();
            if (!(key instanceof String)) continue;
            props.put(key, entry.getValue());
        }
        return props;
    }

    public boolean isJPAAnnotationsProcessingEnabled() {
        return true;
    }

    private static class ClassIterator
    implements Iterator<Class<?>> {
        private Iterator<PersistentClass> hibernatePersistentClassIterator;
        private Class<?> future;

        private ClassIterator(Iterator<PersistentClass> hibernatePersistentClassIterator) {
            this.hibernatePersistentClassIterator = hibernatePersistentClassIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.future != null) {
                return true;
            }
            do {
                if (!this.hibernatePersistentClassIterator.hasNext()) {
                    this.future = null;
                    return false;
                }
                PersistentClass pc = this.hibernatePersistentClassIterator.next();
                this.future = pc.getMappedClass();
            } while (this.future == null);
            return true;
        }

        @Override
        public Class<?> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Class<?> result = this.future;
            this.future = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot modify Hibernate Core metadata");
        }
    }
}

