/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer;

import java.lang.annotation.ElementType;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.de.GermanStemFilterFactory;
import org.apache.lucene.analysis.snowball.SnowballPorterFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.analyzer.BlogEntry;
import org.hibernate.search.test.analyzer.Entity1;
import org.hibernate.search.test.analyzer.Entity2;
import org.junit.Assert;
import org.junit.Test;

public class DuplicatedAnalyzerDefinitionTest
extends SearchTestBase {
    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[0];
    }

    @Test
    public void testDuplicatedAnalyzerDefinitionThrowsException() throws Exception {
        Configuration config = new Configuration();
        config.addAnnotatedClass(Entity1.class);
        config.addAnnotatedClass(Entity2.class);
        config.setProperty("hibernate.search.default.directory_provider", "local-heap");
        try {
            config.buildSessionFactory();
            Assert.fail((String)"Session creation should have failed due to duplicate analyzer definition");
        }
        catch (SearchException e) {
            Assert.assertEquals((Object)"HSEARCH000330: Multiple analyzer definitions with the same name: 'my-analyzer'.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDuplicatedProgrammaticAnalyzerDefinitionThrowsException() throws Exception {
        Configuration config = new Configuration();
        config.getProperties().put("hibernate.search.model_mapping", this.createSearchMapping());
        config.setProperty("hibernate.search.default.directory_provider", "local-heap");
        try {
            config.buildSessionFactory();
            Assert.fail((String)"Session creation should have failed due to duplicate analyzer definition");
        }
        catch (SearchException e) {
            Assert.assertEquals((Object)"HSEARCH000330: Multiple analyzer definitions with the same name: 'english'.", (Object)e.getMessage());
        }
    }

    private SearchMapping createSearchMapping() {
        SearchMapping mapping = new SearchMapping();
        mapping.analyzerDef("english", StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(SnowballPorterFilterFactory.class).analyzerDef("english", StandardTokenizerFactory.class).filter(LowerCaseFilterFactory.class).filter(GermanStemFilterFactory.class).entity(BlogEntry.class).indexed().property("title", ElementType.METHOD);
        return mapping;
    }
}

