/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.util.Map;
import org.hibernate.search.backend.configuration.impl.IndexWriterSetting;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.impl.IndexShardingStrategyIndexManagerSelector;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.IndexManagerSelector;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.FSDirectoryProvider;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.configuration.ConfigurationReadTestCase;
import org.hibernate.search.test.configuration.UselessShardingStrategy;
import org.hibernate.search.test.query.Author;
import org.hibernate.search.test.query.Book;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class ShardsConfigurationTest
extends ConfigurationReadTestCase {
    @Override
    public void configure(Map<String, Object> cfg) {
        super.configure(cfg);
        cfg.put("hibernate.search.default.sharding_strategy.nbr_of_shards", "2");
        cfg.put("hibernate.search.default.directory_provider", "filesystem");
        cfg.put("hibernate.search.default.2.directory_provider", "local-heap");
        cfg.put("hibernate.search.Documents.indexwriter.max_buffered_docs", "4");
        cfg.put("hibernate.search.Documents.indexwriter.max_merge_docs", "5");
        cfg.put("hibernate.search.Documents.sharding_strategy.nbr_of_shards", "4");
        cfg.put("hibernate.search.Documents.sharding_strategy", UselessShardingStrategy.class.getCanonicalName());
        cfg.put("hibernate.search.Documents.sharding_strategy.test.system.default", "45");
        cfg.put("hibernate.search.Documents.sharding_strategy.test.output", "70");
        cfg.put("hibernate.search.Documents.0.indexwriter.max_merge_docs", "57");
        cfg.put("hibernate.search.Documents.0.directory_provider", RAMDirectoryProvider.class.getCanonicalName());
        cfg.put("hibernate.search.Documents.0.indexwriter.max_buffered_docs", "58");
        cfg.put("hibernate.search.Documents.1.indexwriter.max_merge_docs", "11");
        cfg.put("hibernate.search.Documents.1.indexwriter.max_buffered_docs", "12");
        cfg.put("hibernate.search.Documents.1.indexwriter.term_index_interval", "12");
    }

    @Test
    public void testCorrectNumberOfShardsDetected() {
        EntityIndexBinding indexBindingForDocument = (EntityIndexBinding)this.getExtendedSearchIntegrator().getIndexBindings().get(Document.class);
        IndexManager[] documentManagers = indexBindingForDocument.getIndexManagers();
        Assert.assertNotNull((Object)documentManagers);
        Assert.assertEquals((long)4L, (long)documentManagers.length);
        EntityIndexBinding indexBindingForBooks = (EntityIndexBinding)this.getExtendedSearchIntegrator().getIndexBindings().get(Book.class);
        IndexManager[] bookManagers = indexBindingForBooks.getIndexManagers();
        Assert.assertNotNull((Object)bookManagers);
        Assert.assertEquals((long)2L, (long)bookManagers.length);
    }

    @Test
    public void testSelectionOfShardingStrategy() {
        IndexManagerSelector selector = ((EntityIndexBinding)this.getExtendedSearchIntegrator().getIndexBindings().get(Document.class)).getIndexManagerSelector();
        Assert.assertNotNull((Object)selector);
        Assert.assertEquals(selector.getClass(), IndexShardingStrategyIndexManagerSelector.class);
        Assert.assertEquals((long)4L, (long)selector.all().size());
        Assert.assertEquals((String)"Expected the useless strategy to be used (never returns any shard)", (long)0L, (long)selector.forExisting((IndexedTypeIdentifier)new PojoIndexedTypeIdentifier(Document.class), null, null).size());
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testShardingSettingsInherited() {
        IndexManager[] indexManagers = ((EntityIndexBinding)this.getExtendedSearchIntegrator().getIndexBindings().get(Document.class)).getIndexManagers();
        Assert.assertTrue((boolean)(ShardsConfigurationTest.getDirectoryProvider(indexManagers[0]) instanceof RAMDirectoryProvider));
        Assert.assertTrue((boolean)(ShardsConfigurationTest.getDirectoryProvider(indexManagers[1]) instanceof FSDirectoryProvider));
        Assert.assertTrue((boolean)(ShardsConfigurationTest.getDirectoryProvider(indexManagers[2]) instanceof RAMDirectoryProvider));
        this.assertValueIsSet(Document.class, 0, IndexWriterSetting.MAX_BUFFERED_DOCS, 58);
        this.assertValueIsSet(Document.class, 1, IndexWriterSetting.MAX_BUFFERED_DOCS, 12);
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testShardN2UsesDefaults() {
        this.assertValueIsSet(Document.class, 2, IndexWriterSetting.MAX_BUFFERED_DOCS, 4);
        this.assertValueIsSet(Document.class, 2, IndexWriterSetting.MERGE_FACTOR, 100);
        this.assertValueIsDefault(Document.class, 2, IndexWriterSetting.RAM_BUFFER_SIZE);
        this.assertValueIsSet(Document.class, 2, IndexWriterSetting.MAX_BUFFERED_DOCS, 4);
        this.assertValueIsSet(Document.class, 2, IndexWriterSetting.MAX_MERGE_DOCS, 5);
        this.assertValueIsDefault(Document.class, 2, IndexWriterSetting.RAM_BUFFER_SIZE);
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testShardN1_ExplicitParams() {
        this.assertValueIsSet(Document.class, 1, IndexWriterSetting.MAX_BUFFERED_DOCS, 12);
        this.assertValueIsSet(Document.class, 1, IndexWriterSetting.MAX_MERGE_DOCS, 11);
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class, Author.class, Document.class};
    }

    private static DirectoryProvider getDirectoryProvider(IndexManager indexManager) {
        DirectoryBasedIndexManager dpBasedManager = (DirectoryBasedIndexManager)indexManager;
        return dpBasedManager.getDirectoryProvider();
    }
}

