/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.polymorphism;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.embedded.polymorphism.DerivedLevel2;
import org.hibernate.search.test.embedded.polymorphism.Level1;
import org.hibernate.search.test.embedded.polymorphism.Level2;
import org.hibernate.search.test.embedded.polymorphism.Level3;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1241")
public class PolymorphicAssociationTest
extends SearchTestBase {
    private static final String INIT_NAME = "initname";
    private static final String EDIT_NAME = "editname";

    @Test
    public void testPolymorphicAssociation() {
        this.prepareEntities(INIT_NAME);
        this.changeLevel3Name(INIT_NAME, EDIT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareEntities(String level3Name) {
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            Level1 level1 = new Level1();
            DerivedLevel2 level2 = new DerivedLevel2();
            Level3 level3 = new Level3();
            level1.setLevel2Child(level2);
            level2.setLevel1Parent(level1);
            level2.setLevel3Child(level3);
            level3.setLevel2Parent(level2);
            level3.setName(level3Name);
            session.save((Object)level1);
            session.save((Object)level2);
            session.save((Object)level3);
            transaction.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeLevel3Name(String currentName, String newName) {
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());){
            Transaction transaction = fullTextSession.beginTransaction();
            TermQuery q = new TermQuery(new Term("name", currentName));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)q, new Class[0]);
            Assert.assertEquals((long)1L, (long)fullTextQuery.getResultSize());
            Level3 level3 = (Level3)fullTextQuery.list().get(0);
            level3.setName(newName);
            transaction.commit();
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Level1.class, Level2.class, DerivedLevel2.class, Level3.class};
    }
}

