/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.worker;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.worker.Employee;
import org.hibernate.search.test.engine.worker.Employer;
import org.hibernate.search.testsupport.concurrency.ConcurrentRunner;
import org.junit.Assert;
import org.junit.Test;

public class WorkerTestCase
extends SearchTestBase {
    @Test
    public void testConcurrency() throws Exception {
        int numberOfThreads = 15;
        int iteration = 100;
        Work work = new Work(this.getSessionFactory(), this.isWorkerSync());
        ReverseWork reverseWork = new ReverseWork(this.getSessionFactory());
        long start = System.nanoTime();
        new ConcurrentRunner(iteration * 2, numberOfThreads, i -> i % 2 == 0 ? work : reverseWork).setTimeout(1L, TimeUnit.MINUTES).execute();
        System.out.println(iteration + " iterations (8 tx per iteration) in " + numberOfThreads + " threads: " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
    }

    private static RuntimeException tryClose(RuntimeException exception, Runnable runnable) {
        try {
            runnable.run();
            return exception;
        }
        catch (RuntimeException e) {
            if (exception != null) {
                exception.addSuppressed(e);
                return exception;
            }
            return e;
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Employee.class, Employer.class};
    }

    protected boolean isWorkerSync() {
        return true;
    }

    protected static final class ReverseWork
    implements Runnable {
        private final SessionFactory sf;

        public ReverseWork(SessionFactory sf) {
            this.sf = sf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeException exception = null;
            Session s = null;
            Transaction tx = null;
            try {
                s = this.sf.openSession();
                tx = s.beginTransaction();
                Employer er = new Employer();
                er.setName("RH");
                s.persist((Object)er);
                Employee ee = new Employee();
                ee.setName("Emmanuel");
                s.persist((Object)ee);
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                er.setName("RH2");
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                ee.setName("Emmanuel2");
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                s.delete((Object)er);
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                s.delete((Object)ee);
                tx.commit();
                s.close();
            }
            catch (RuntimeException e) {
                exception = e;
            }
            finally {
                if (tx != null && tx.getStatus() == TransactionStatus.ACTIVE) {
                    exception = WorkerTestCase.tryClose(exception, () -> ((Transaction)tx).rollback());
                }
                if (s != null && s.isOpen()) {
                    exception = WorkerTestCase.tryClose(exception, () -> s.close());
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    protected static final class Work
    implements Runnable {
        private final SessionFactory sf;
        private final boolean isWorkerSync;

        public Work(SessionFactory sf, boolean isWorkerSync) {
            this.sf = sf;
            this.isWorkerSync = isWorkerSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RuntimeException exception = null;
            Session s = null;
            Transaction tx = null;
            try {
                boolean results;
                s = this.sf.openSession();
                tx = s.beginTransaction();
                Employer er = new Employer();
                er.setName("RH");
                s.persist((Object)er);
                Employee ee = new Employee();
                ee.setName("Emmanuel");
                s.persist((Object)ee);
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                ee.setName("John");
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                er.setName("JBoss");
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                TermQuery query = new TermQuery(new Term("name", "john"));
                boolean bl = results = Search.getFullTextSession((Session)s).createFullTextQuery((Query)query, new Class[0]).list().size() > 0;
                if (this.isWorkerSync) {
                    Assert.assertTrue((boolean)results);
                }
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                er = (Employer)s.get(Employer.class, (Serializable)Long.valueOf(er.getId()));
                s.delete((Object)er);
                tx.commit();
                s.close();
                s = this.sf.openSession();
                tx = s.beginTransaction();
                ee = (Employee)s.get(Employee.class, (Serializable)Long.valueOf(ee.getId()));
                s.delete((Object)ee);
                tx.commit();
                s.close();
            }
            catch (RuntimeException e) {
                exception = e;
            }
            finally {
                if (tx != null && tx.getStatus() == TransactionStatus.ACTIVE) {
                    exception = WorkerTestCase.tryClose(exception, () -> ((Transaction)tx).rollback());
                }
                if (s != null && s.isOpen()) {
                    exception = WorkerTestCase.tryClose(exception, () -> s.close());
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

