/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine.worker.duplication;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.impl.WorkQueue;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.engine.worker.duplication.EmailAddress;
import org.hibernate.search.test.engine.worker.duplication.Person;
import org.hibernate.search.test.engine.worker.duplication.SpecialPerson;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class WorkDuplicationTest
extends SearchTestBase {
    @Test
    public void testNoWorkDuplication() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        SpecialPerson person = new SpecialPerson();
        person.setName("Joe Smith");
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.setAddress("foo@foobar.com");
        emailAddress.setDefaultAddress(true);
        person.addEmailAddress(emailAddress);
        s.persist((Object)person);
        tx.commit();
        tx = s.beginTransaction();
        String searchQuery = "Joe";
        QueryParser parser = new QueryParser("Content", TestConstants.standardAnalyzer);
        Query luceneQuery = parser.parse(searchQuery);
        FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
        List results = query.list();
        Assert.assertTrue((String)"We should have a hit", (results.size() == 1 ? 1 : 0) != 0);
        tx.commit();
        tx = s.beginTransaction();
        int id = person.getId();
        person = (SpecialPerson)s.get(SpecialPerson.class, (Serializable)Integer.valueOf(id));
        s.delete((Object)person);
        tx.commit();
        tx = s.beginTransaction();
        String indexName = ((EntityIndexBinding)this.getExtendedSearchIntegrator().getIndexBindings().get(SpecialPerson.class)).getIndexManagers()[0].getIndexName();
        Assert.assertEquals((String)"We should have no hit", (long)0L, (long)this.getNumberOfDocumentsInIndexByQuery(indexName, "Content", "Joe"));
        tx.commit();
        s.close();
    }

    @Test
    public void testAddWorkGetReplacedByDeleteWork() throws Exception {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        ExtendedSearchIntegrator integrator = (ExtendedSearchIntegrator)fullTextSession.getSearchFactory().unwrap(ExtendedSearchIntegrator.class);
        SpecialPerson person = new SpecialPerson();
        person.setName("Joe Smith");
        EmailAddress emailAddress = new EmailAddress();
        emailAddress.setAddress("foo@foobar.com");
        emailAddress.setDefaultAddress(true);
        person.addEmailAddress(emailAddress);
        WorkQueue plannerEngine = new WorkQueue(integrator);
        plannerEngine.add(new Work((Object)person, (Serializable)Integer.valueOf(1), WorkType.ADD));
        plannerEngine.prepareWorkPlan();
        List sealedQueue = plannerEngine.getSealedQueue();
        Assert.assertEquals((String)"There should only be one job in the queue", (long)1L, (long)sealedQueue.size());
        Assert.assertTrue((String)"Wrong job type", (boolean)(sealedQueue.get(0) instanceof AddLuceneWork));
        plannerEngine.add(new Work((Object)person, (Serializable)Integer.valueOf(1), WorkType.DELETE));
        plannerEngine.prepareWorkPlan();
        sealedQueue = plannerEngine.getSealedQueue();
        Assert.assertEquals((String)"Jobs should have countered each other", (long)0L, (long)sealedQueue.size());
        fullTextSession.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Person.class, EmailAddress.class, SpecialPerson.class};
    }
}

