/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.junit.Assert;
import org.junit.Test;

public class EdgeCaseFacetTest
extends AbstractFacetTest {
    private final String facetName = "ccs";

    @Test
    public void testFacetingOnEmptyIndex() throws Exception {
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity_string_facet_string").discrete().createFacetingRequest();
        FullTextQuery query = this.queryHondaWithFacet(request);
        List facetList = query.getFacetManager().getFacets("ccs");
        Assert.assertEquals((String)"Wrong number of facets", (long)0L, (long)facetList.size());
    }

    private FullTextQuery queryHondaWithFacet(FacetingRequest request) {
        Query luceneQuery = this.queryBuilder(Car.class).keyword().onField("make").matching((Object)"Honda").createQuery();
        FullTextQuery query = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Car.class});
        query.getFacetManager().enableFaceting(request);
        Assert.assertEquals((String)"Wrong number of query matches", (long)0L, (long)query.getResultSize());
        return query;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class};
    }

    @Override
    public void loadTestData(Session session) {
    }
}

