/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.session;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.session.Categorie;
import org.hibernate.search.test.session.Domain;
import org.hibernate.search.test.session.Email;
import org.hibernate.search.test.session.Entite;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class MassIndexTest
extends SearchTestBase {
    @Test
    public void testBatchSize() throws Exception {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        int loop = 14;
        s.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                for (int i = 0; i < 14; ++i) {
                    Statement statmt = connection.createStatement();
                    statmt.executeUpdate("insert into Domain(id, name) values( + " + (i + 1) + ", 'sponge" + i + "')");
                    statmt.executeUpdate("insert into Email(id, title, body, header, domain_id) values( + " + (i + 1) + ", 'Bob Sponge', 'Meet the guys who create the software', 'nope', " + (i + 1) + ")");
                    statmt.close();
                }
            }
        });
        tx.commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        ScrollableResults results = s.createCriteria(Email.class).scroll(ScrollMode.FORWARD_ONLY);
        int index = 0;
        while (results.next()) {
            s.index(results.get(0));
            if (++index % 5 != 0) continue;
            s.clear();
        }
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.stopAnalyzer);
        List result = s.createFullTextQuery(parser.parse("body:create"), new Class[0]).list();
        Assert.assertEquals((long)14L, (long)result.size());
        for (Object object : result) {
            s.delete(object);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testTransactional() throws Exception {
        int i;
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        int loop = 4;
        for (int i2 = 0; i2 < 4; ++i2) {
            Email email = new Email();
            email.setId((long)i2 + 1L);
            email.setTitle("JBoss World Berlin");
            email.setBody("Meet the guys who wrote the software");
            s.persist((Object)email);
        }
        tx.commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        QueryParser parser = new QueryParser("id", TestConstants.stopAnalyzer);
        List result = s.createFullTextQuery(parser.parse("body:create"), new Class[0]).list();
        Assert.assertEquals((long)0L, (long)result.size());
        tx.commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        s.getTransaction().begin();
        s.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                Statement stmt = connection.createStatement();
                stmt.executeUpdate("update Email set body='Meet the guys who write the software'");
                stmt.close();
            }
        });
        s.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                Statement stmt = connection.createStatement();
                stmt.executeUpdate("insert into Email(id, title, body, header) values( + 5, 'Bob Sponge', 'Meet the guys who create the software', 'nope')");
                stmt.close();
            }
        });
        s.getTransaction().commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        parser = new QueryParser("id", TestConstants.stopAnalyzer);
        result = s.createFullTextQuery(parser.parse("body:write"), new Class[0]).list();
        Assert.assertEquals((long)0L, (long)result.size());
        result = s.createCriteria(Email.class).list();
        for (i = 0; i < 2; ++i) {
            s.index(result.get(i));
        }
        tx.commit();
        s.index(result.get(2));
        tx = s.beginTransaction();
        for (i = 3; i < 4; ++i) {
            s.index(result.get(i));
        }
        tx.commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        Email email = (Email)s.get(Email.class, (Serializable)Long.valueOf(5L));
        s.index((Object)email);
        tx.commit();
        s.close();
        s = Search.getFullTextSession((Session)this.openSession());
        tx = s.beginTransaction();
        result = s.createFullTextQuery(parser.parse("body:create"), new Class[0]).list();
        Assert.assertEquals((long)1L, (long)result.size());
        tx.commit();
        s.close();
    }

    @Test
    public void testLazyLoading() throws Exception {
        Categorie cat = new Categorie("Livre");
        Entite ent = new Entite("Le temple des songes", cat);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cat);
        s.persist((Object)ent);
        tx.commit();
        s.close();
        s = this.getSessionWithAutoCommit();
        FullTextSession session = Search.getFullTextSession((Session)s);
        TermQuery luceneQuery = new TermQuery(new Term("categorie.nom", "livre"));
        List result = session.createFullTextQuery((Query)luceneQuery, new Class[]{Entite.class}).list();
        Assert.assertEquals((long)1L, (long)result.size());
        s.close();
        s = this.getSessionWithAutoCommit();
        ent = (Entite)s.get(Entite.class, (Serializable)ent.getId());
        session = Search.getFullTextSession((Session)s);
        session.index((Object)ent);
        s.close();
        s = this.getSessionWithAutoCommit();
        session = Search.getFullTextSession((Session)s);
        luceneQuery = new TermQuery(new Term("categorie.nom", "livre"));
        result = session.createFullTextQuery((Query)luceneQuery, new Class[]{Entite.class}).list();
        Assert.assertEquals((String)"test lazy loading and indexing", (long)1L, (long)result.size());
        s.close();
        s = this.getSessionWithAutoCommit();
        Iterator it = s.createQuery("from Entite where id = :id").setParameter("id", (Object)ent.getId()).iterate();
        session = Search.getFullTextSession((Session)s);
        while (it.hasNext()) {
            ent = (Entite)it.next();
            session.index((Object)ent);
        }
        s.close();
        s = this.getSessionWithAutoCommit();
        session = Search.getFullTextSession((Session)s);
        luceneQuery = new TermQuery(new Term("categorie.nom", "livre"));
        result = session.createFullTextQuery((Query)luceneQuery, new Class[]{Entite.class}).list();
        Assert.assertEquals((String)"test lazy loading and indexing", (long)1L, (long)result.size());
        s.close();
    }

    private Session getSessionWithAutoCommit() {
        Session s = this.openSession();
        s.doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                connection.setAutoCommit(true);
            }
        });
        return s;
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.batch_size", "5");
        cfg.put("hibernate.search.analyzer", StopAnalyzer.class.getName());
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Email.class, Entite.class, Categorie.class, Domain.class};
    }
}

