/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.BridgeException;
import org.hibernate.search.bridge.builtin.StringEncodingCalendarBridge;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.Cloud;
import org.hibernate.search.test.bridge.CloudType;
import org.hibernate.search.test.bridge.IncorrectGet;
import org.hibernate.search.test.bridge.IncorrectObjectToString;
import org.hibernate.search.test.bridge.IncorrectSet;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class BridgeTest
extends SearchTestBase {
    @Test
    public void testDefaultAndNullBridges() throws Exception {
        Cloud cloud = new Cloud();
        cloud.setMyDate(null);
        cloud.setDouble1(null);
        cloud.setDouble2(2.1);
        cloud.setIntegerv1(null);
        cloud.setIntegerv2(2);
        cloud.setFloat1(null);
        cloud.setFloat2(2.1f);
        cloud.setLong1(null);
        cloud.setLong2(2L);
        cloud.setString(null);
        cloud.setType(CloudType.DOG);
        cloud.setChar1(null);
        cloud.setChar2('P');
        cloud.setStorm(false);
        cloud.setClazz(Cloud.class);
        cloud.setUri(new URI("http://www.hibernate.org"));
        cloud.setUrl(new URL("http://www.hibernate.org"));
        cloud.setUuid(UUID.fromString("f49c6ba8-8d7f-417a-a255-d594dddf729f"));
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cloud);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)NumericRangeQuery.newDoubleRange((String)"double2", (Double)2.1, (Double)2.1, (boolean)true, (boolean)true), BooleanClause.Occur.MUST).add((Query)NumericRangeQuery.newFloatRange((String)"float2", (Float)Float.valueOf(2.1f), (Float)Float.valueOf(2.1f), (boolean)true, (boolean)true), BooleanClause.Occur.MUST).add((Query)NumericRangeQuery.newIntRange((String)"integerv2", (Integer)2, (Integer)3, (boolean)true, (boolean)true), BooleanClause.Occur.MUST).add((Query)NumericRangeQuery.newLongRange((String)"long2", (Long)2L, (Long)3L, (boolean)true, (boolean)true), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("type", "dog")), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("storm", "false")), BooleanClause.Occur.MUST).build();
        List result = session.createFullTextQuery((Query)booleanQuery, new Class[0]).list();
        Assert.assertEquals((String)"find primitives and do not fail on null", (long)1L, (long)result.size());
        booleanQuery = new BooleanQuery.Builder().add((Query)NumericRangeQuery.newDoubleRange((String)"double1", (Double)2.1, (Double)2.1, (boolean)true, (boolean)true), BooleanClause.Occur.MUST).add((Query)NumericRangeQuery.newFloatRange((String)"float1", (Float)Float.valueOf(2.1f), (Float)Float.valueOf(2.1f), (boolean)true, (boolean)true), BooleanClause.Occur.MUST).add((Query)NumericRangeQuery.newIntRange((String)"integerv1", (Integer)2, (Integer)3, (boolean)true, (boolean)true), BooleanClause.Occur.MUST).add((Query)NumericRangeQuery.newLongRange((String)"long1", (Long)2L, (Long)3L, (boolean)true, (boolean)true), BooleanClause.Occur.MUST).build();
        result = session.createFullTextQuery((Query)booleanQuery, new Class[0]).list();
        Assert.assertEquals((String)"null elements should not be stored", (long)0L, (long)result.size());
        Query query = parser.parse("type:dog");
        result = session.createFullTextQuery(query, new Class[0]).setProjection(new String[]{"type"}).list();
        Assert.assertEquals((String)"Enum projection works", (long)1L, (long)result.size());
        query = new TermQuery(new Term("clazz", Cloud.class.getName()));
        result = session.createFullTextQuery(query, new Class[0]).setProjection(new String[]{"clazz"}).list();
        Assert.assertEquals((String)"Clazz projection works", (long)1L, (long)result.size());
        Assert.assertEquals((String)"Clazz projection works", (Object)Cloud.class.getName(), (Object)((Class)((Object[])result.get(0))[0]).getName());
        BooleanQuery bQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("uri", "http://www.hibernate.org")), BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("url", "http://www.hibernate.org")), BooleanClause.Occur.MUST).build();
        result = session.createFullTextQuery((Query)bQuery, new Class[0]).setProjection(new String[]{"clazz"}).list();
        Assert.assertEquals((String)"Clazz projection works", (long)1L, (long)result.size());
        bQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("uuid", "f49c6ba8-8d7f-417a-a255-d594dddf729f")), BooleanClause.Occur.MUST).build();
        result = session.createFullTextQuery((Query)bQuery, new Class[0]).setProjection(new String[]{"clazz"}).list();
        Assert.assertEquals((String)"Clazz projection works", (long)1L, (long)result.size());
        query = parser.parse("char1:[" + String.valueOf('\u0000') + " TO " + String.valueOf('\uffff') + "]");
        result = session.createFullTextQuery(query, new Class[0]).setProjection(new String[]{"char1"}).list();
        Assert.assertEquals((String)"Null elements should not be stored, CharacterBridge is not working", (long)0L, (long)result.size());
        query = parser.parse("char2:P");
        result = session.createFullTextQuery(query, new Class[0]).setProjection(new String[]{"char2"}).list();
        Assert.assertEquals((String)"Wrong results number, CharacterBridge is not working", (long)1L, (long)result.size());
        Assert.assertEquals((String)"Wrong result, CharacterBridge is not working", (Object)Character.valueOf('P'), (Object)((Object[])result.get(0))[0]);
        tx.commit();
        s.close();
    }

    @Test
    public void testCustomBridges() throws Exception {
        Cloud cloud = new Cloud();
        cloud.setCustomFieldBridge("This is divided by 2");
        cloud.setCustomStringBridge("This is div by 4");
        cloud.setChar2('s');
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cloud);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser("id", TestConstants.simpleAnalyzer);
        Query query = parser.parse("customFieldBridge:This AND customStringBridge:This");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"Properties not mapped", (long)1L, (long)result.size());
        query = parser.parse("customFieldBridge:by AND customStringBridge:is");
        result = session.createFullTextQuery(query, new Class[0]).list();
        Assert.assertEquals((String)"Custom types not taken into account", (long)0L, (long)result.size());
        tx.commit();
        s.close();
    }

    @Test
    public void testDateBridge() throws Exception {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("Europe/Rome"), Locale.ROOT);
        c.set(2000, 11, 15, 3, 43, 2);
        c.set(14, 5);
        Date date = new Date(c.getTimeInMillis());
        Cloud cloud = new Cloud();
        cloud.setMyDate(date);
        cloud.setDateDay(date);
        cloud.setDateHour(date);
        cloud.setDateMillisecond(date);
        cloud.setDateMinute(date);
        cloud.setDateMonth(date);
        cloud.setDateSecond(date);
        cloud.setDateYear(date);
        cloud.setChar2('s');
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cloud);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        Date myDate = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newLongRange((String)"myDate", (Long)myDate.getTime(), (Long)myDate.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateDay = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.DAY);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"dateDay", (Long)dateDay.getTime(), (Long)dateDay.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateMonth = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.MONTH);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"dateMonth", (Long)dateMonth.getTime(), (Long)dateMonth.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateYear = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.YEAR);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"dateYear", (Long)dateYear.getTime(), (Long)dateYear.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateHour = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.HOUR);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"dateHour", (Long)dateHour.getTime(), (Long)dateHour.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateMinute = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.MINUTE);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"dateMinute", (Long)dateMinute.getTime(), (Long)dateMinute.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateSecond = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.SECOND);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"dateSecond", (Long)dateSecond.getTime(), (Long)dateSecond.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateMillisecond = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"dateMillisecond", (Long)dateMillisecond.getTime(), (Long)dateMillisecond.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        List result = session.createFullTextQuery((Query)booleanQuery, new Class[0]).list();
        Assert.assertEquals((String)"Date not found or not properly truncated", (long)1L, (long)result.size());
        tx.commit();
        s.close();
    }

    @Test
    public void testCalendarBridge() throws Exception {
        Cloud cloud = new Cloud();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Rome"), Locale.ROOT);
        calendar.set(2000, 11, 15, 3, 43, 2);
        calendar.set(14, 5);
        cloud.setMyCalendar(calendar);
        cloud.setCalendarDay(calendar);
        cloud.setCalendarHour(calendar);
        cloud.setCalendarMillisecond(calendar);
        cloud.setCalendarMinute(calendar);
        cloud.setCalendarMonth(calendar);
        cloud.setCalendarSecond(calendar);
        cloud.setCalendarYear(calendar);
        cloud.setChar2('s');
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cloud);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Date date = calendar.getTime();
        BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        Date myDate = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
        NumericRangeQuery numericRangeQuery = NumericRangeQuery.newLongRange((String)"myCalendar", (Long)myDate.getTime(), (Long)myDate.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateDay = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.DAY);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"calendarDay", (Long)dateDay.getTime(), (Long)dateDay.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateMonth = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.MONTH);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"calendarMonth", (Long)dateMonth.getTime(), (Long)dateMonth.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateYear = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.YEAR);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"calendarYear", (Long)dateYear.getTime(), (Long)dateYear.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateHour = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.HOUR);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"calendarHour", (Long)dateHour.getTime(), (Long)dateHour.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateMinute = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.MINUTE);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"calendarMinute", (Long)dateMinute.getTime(), (Long)dateMinute.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateSecond = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.SECOND);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"calendarSecond", (Long)dateSecond.getTime(), (Long)dateSecond.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        Date dateMillisecond = DateTools.round((Date)date, (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
        numericRangeQuery = NumericRangeQuery.newLongRange((String)"calendarMillisecond", (Long)dateMillisecond.getTime(), (Long)dateMillisecond.getTime(), (boolean)true, (boolean)true);
        booleanQueryBuilder.add((Query)numericRangeQuery, BooleanClause.Occur.MUST);
        BooleanQuery booleanQuery = booleanQueryBuilder.build();
        List result = session.createFullTextQuery((Query)booleanQuery, new Class[0]).list();
        Assert.assertEquals((String)"Calendar not found or not properly truncated", (long)1L, (long)result.size());
        tx.commit();
        s.close();
        StringEncodingCalendarBridge bridge = new StringEncodingCalendarBridge();
        HashMap<String, String> bridgeParams = new HashMap<String, String>();
        bridgeParams.put("resolution", Resolution.YEAR.toString());
        bridge.setParameterValues(bridgeParams);
        Assert.assertEquals((Object)"2000", (Object)bridge.objectToString((Object)calendar));
        bridgeParams.put("resolution", Resolution.DAY.toString());
        bridge.setParameterValues(bridgeParams);
        Assert.assertEquals((Object)"20001215", (Object)bridge.objectToString((Object)calendar));
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testDateBridgeStringEncoding() throws Exception {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("Europe/Rome"), Locale.ROOT);
        c.set(2000, 11, 15, 3, 43, 2);
        c.set(14, 5);
        Date date = new Date(c.getTimeInMillis());
        Cloud cloud = new Cloud();
        cloud.setDateDay(date);
        cloud.setChar2('s');
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cloud);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        TermQuery termQuery = new TermQuery(new Term("dateDayStringEncoding", DateTools.dateToString((Date)date, (DateTools.Resolution)DateTools.Resolution.DAY)));
        List result = session.createFullTextQuery((Query)termQuery, new Class[0]).list();
        Assert.assertEquals((String)"Date not found or not properly truncated", (long)1L, (long)result.size());
        tx.commit();
        s.close();
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testCalendarBridgeStringEncoding() throws Exception {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("Europe/Rome"), Locale.ROOT);
        c.set(2000, 11, 15, 3, 43, 2);
        c.set(14, 5);
        Cloud cloud = new Cloud();
        cloud.setCalendarDay(c);
        cloud.setChar2('s');
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)cloud);
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        TermQuery termQuery = new TermQuery(new Term("calendarDayStringEncoding", DateTools.dateToString((Date)c.getTime(), (DateTools.Resolution)DateTools.Resolution.DAY)));
        List result = session.createFullTextQuery((Query)termQuery, new Class[0]).list();
        Assert.assertEquals((String)"Calendar not found or not properly truncated", (long)1L, (long)result.size());
        tx.commit();
        s.close();
    }

    @Test
    public void testIncorrectSetBridge() throws Exception {
        IncorrectSet incorrect = new IncorrectSet();
        incorrect.setSubIncorrect(new IncorrectSet.SubIncorrect());
        incorrect.getSubIncorrect().setName("This is a name not a class");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        try {
            s.persist((Object)incorrect);
            s.flush();
            s.flushToIndexes();
            Assert.fail((String)"Incorrect bridge should fail");
        }
        catch (BridgeException e) {
            tx.rollback();
        }
        catch (HibernateException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof BridgeException) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("class: " + IncorrectSet.class.getName()));
                Assert.assertTrue((boolean)throwable.getMessage().contains("path: subIncorrect.name"));
                tx.rollback();
            } else {
                e.printStackTrace();
                Assert.fail((String)("Incorrect bridge should raise a SearchException: " + e.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Incorrect bridge should raise a SearchException");
        }
        s.close();
    }

    @Test
    public void testIncorrectGetBridge() throws Exception {
        IncorrectGet incorrect = new IncorrectGet();
        incorrect.setSubIncorrect(new IncorrectGet.SubIncorrect());
        incorrect.getSubIncorrect().setName("This is a name not a class");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        s.persist((Object)incorrect);
        tx.commit();
        s.clear();
        tx = s.beginTransaction();
        QueryBuilder builder = s.getSearchFactory().buildQueryBuilder().forEntity(IncorrectGet.class).get();
        Query query = builder.keyword().onField("subIncorrect.name").matching((Object)"name").createQuery();
        try {
            FullTextQuery textQuery = s.createFullTextQuery(query, new Class[]{IncorrectGet.class}).setProjection(new String[]{"subIncorrect.name"});
            textQuery.list();
            Assert.fail((String)"Incorrect bridge should fail");
        }
        catch (BridgeException e) {
            tx.rollback();
        }
        catch (HibernateException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof BridgeException) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("class: " + IncorrectGet.class.getName()));
                Assert.assertTrue((boolean)throwable.getMessage().contains("path: subIncorrect.name"));
                tx.rollback();
            } else {
                e.printStackTrace();
                Assert.fail((String)("Incorrect bridge should raise a SearchException: " + e.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Incorrect bridge should raise a SearchException");
        }
        s.close();
    }

    @Test
    public void testIncorrectObjectToStringBridge() throws Exception {
        IncorrectObjectToString incorrect = new IncorrectObjectToString();
        incorrect.setName("test");
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        try {
            s.persist((Object)incorrect);
            s.flush();
            s.flushToIndexes();
            Assert.fail((String)"Incorrect bridge should fail");
        }
        catch (BridgeException e) {
            tx.rollback();
        }
        catch (HibernateException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof BridgeException) {
                Assert.assertTrue((boolean)throwable.getMessage().contains("class: " + IncorrectObjectToString.class.getName()));
                Assert.assertTrue((boolean)throwable.getMessage().contains("path: id"));
                tx.rollback();
            } else {
                e.printStackTrace();
                Assert.fail((String)("Incorrect bridge should raise a SearchException: " + e.toString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Incorrect bridge should raise a SearchException");
        }
        s.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Cloud.class, IncorrectSet.class, IncorrectGet.class, IncorrectObjectToString.class};
    }

    @Override
    public void configure(Map<String, Object> cfg) {
        cfg.put("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
    }
}

