/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.search.FullTextSession;
import org.hibernate.search.backend.impl.LocalBackendQueueProcessor;
import org.hibernate.search.backend.impl.blackhole.BlackHoleBackendQueueProcessor;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.test.configuration.BlogEntry;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class CustomBackendTest {
    @Test
    public void test() {
        this.verifyBackendUsage("blackhole", BlackHoleBackendQueueProcessor.class);
        this.verifyBackendUsage("local", LocalBackendQueueProcessor.class);
        this.verifyBackendUsage("lucene", LocalBackendQueueProcessor.class);
        this.verifyBackendUsage(BlackHoleBackendQueueProcessor.class);
        this.verifyBackendUsage(LocalBackendQueueProcessor.class);
    }

    private void verifyBackendUsage(String name, Class<? extends BackendQueueProcessor> backendType) {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        FullTextSession ftSession = builder.setProperty("hibernate.search.default.worker.backend", name).addAnnotatedClass(BlogEntry.class).openFullTextSession();
        ExtendedSearchIntegrator integrator = (ExtendedSearchIntegrator)ftSession.getSearchFactory().unwrap(ExtendedSearchIntegrator.class);
        ftSession.close();
        IndexManagerHolder allIndexesManager = integrator.getIndexManagerHolder();
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)allIndexesManager.getIndexManager("org.hibernate.search.test.configuration.BlogEntry");
        BackendQueueProcessor backendQueueProcessor = allIndexesManager.getBackendQueueProcessor(indexManager.getIndexName());
        Assert.assertEquals(backendType, backendQueueProcessor.getClass());
        builder.close();
    }

    public void verifyBackendUsage(Class<? extends BackendQueueProcessor> backendType) {
        this.verifyBackendUsage(backendType.getName(), backendType);
    }
}

