/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.embedded.polymorphism;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-3156")
public class PolymorphicAssociationContainedInTargetTest
extends SearchTestBase {
    private static final String INIT_NAME = "initname";
    private static final String EDIT_NAME = "editname";

    @Test
    public void testPolymorphicAssociationConfiguredType() {
        Throwable throwable;
        FullTextSession fullTextSession2;
        Level3 derivedLevel2Level3;
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            Level1 level1 = new Level1();
            level1.setId(1);
            DerivedLevel2 derivedLevel2 = new DerivedLevel2();
            derivedLevel2.setId(2);
            derivedLevel2Level3 = new Level3();
            derivedLevel2Level3.setId(3);
            derivedLevel2Level3.setName(INIT_NAME);
            level1.setDerivedLevel2Child(derivedLevel2);
            derivedLevel2.setLevel1Parent(level1);
            derivedLevel2.setLevel3Child(derivedLevel2Level3);
            derivedLevel2Level3.setLevel2Parent(derivedLevel2);
            session.save((Object)level1);
            session.save((Object)derivedLevel2);
            session.save((Object)derivedLevel2Level3);
            transaction.commit();
        }
        session = this.openSession();
        var2_2 = null;
        try {
            fullTextSession2 = Search.getFullTextSession((Session)session);
            throwable = null;
            try {
                Transaction transaction = fullTextSession2.beginTransaction();
                derivedLevel2Level3 = (Level3)session.get(Level3.class, (Serializable)Integer.valueOf(3));
                derivedLevel2Level3.setName(EDIT_NAME);
                transaction.commit();
            }
            catch (Throwable transaction) {
                throwable = transaction;
                throw transaction;
            }
            finally {
                if (fullTextSession2 != null) {
                    if (throwable != null) {
                        try {
                            fullTextSession2.close();
                        }
                        catch (Throwable transaction) {
                            throwable.addSuppressed(transaction);
                        }
                    } else {
                        fullTextSession2.close();
                    }
                }
            }
        }
        catch (Throwable fullTextSession2) {
            var2_2 = fullTextSession2;
            throw fullTextSession2;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable fullTextSession2) {
                        var2_2.addSuppressed(fullTextSession2);
                    }
                } else {
                    session.close();
                }
            }
        }
        session = this.openSession();
        var2_2 = null;
        try {
            fullTextSession2 = Search.getFullTextSession((Session)session);
            throwable = null;
            try {
                TermQuery q = new TermQuery(new Term("derivedLevel2Child.level3Child.name", EDIT_NAME));
                FullTextQuery fullTextQuery = fullTextSession2.createFullTextQuery((Query)q, new Class[0]);
                Assert.assertEquals((long)1L, (long)fullTextQuery.getResultSize());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fullTextSession2 != null) {
                    if (throwable != null) {
                        try {
                            fullTextSession2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fullTextSession2.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var2_2 = throwable4;
            throw throwable4;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable5) {
                        var2_2.addSuppressed(throwable5);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    @Test
    public void testPolymorphicAssociationNonConfiguredType() {
        Level3 baseLevel2Level3;
        try (Session session = this.openSession();){
            Transaction transaction = session.beginTransaction();
            Level1 level1 = new Level1();
            level1.setId(1);
            Level2 baseLevel2 = new Level2();
            baseLevel2.setId(4);
            baseLevel2Level3 = new Level3();
            baseLevel2Level3.setId(5);
            baseLevel2Level3.setName(INIT_NAME);
            baseLevel2.setLevel3Child(baseLevel2Level3);
            baseLevel2Level3.setLevel2Parent(baseLevel2);
            session.save((Object)level1);
            session.save((Object)baseLevel2);
            session.save((Object)baseLevel2Level3);
            transaction.commit();
        }
        session = this.openSession();
        var2_2 = null;
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)session);){
            Transaction transaction = fullTextSession.beginTransaction();
            baseLevel2Level3 = (Level3)session.get(Level3.class, (Serializable)Integer.valueOf(5));
            baseLevel2Level3.setName(EDIT_NAME);
            transaction.commit();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (session != null) {
                if (var2_2 != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    session.close();
                }
            }
        }
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Level1.class, Level2.class, DerivedLevel2.class, Level3.class};
    }

    @Entity(name="Level3")
    static class Level3 {
        @Id
        private Integer id;
        @Field
        private String name;
        @OneToOne(fetch=FetchType.LAZY)
        @ContainedIn
        private Level2 level2Parent;

        Level3() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Level2 getLevel2Parent() {
            return this.level2Parent;
        }

        public void setLevel2Parent(Level2 level2Parent) {
            this.level2Parent = level2Parent;
        }
    }

    @Entity(name="DerivedLevel2")
    static class DerivedLevel2
    extends Level2 {
        @OneToOne
        @ContainedIn
        private Level1 level1Parent;

        DerivedLevel2() {
        }

        public Level1 getLevel1Parent() {
            return this.level1Parent;
        }

        public void setLevel1Parent(Level1 level1Parent) {
            this.level1Parent = level1Parent;
        }
    }

    @Entity(name="Level2")
    static class Level2 {
        @Id
        private Integer id;
        @OneToOne(mappedBy="level2Parent")
        @IndexedEmbedded
        private Level3 level3Child;

        Level2() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public Level3 getLevel3Child() {
            return this.level3Child;
        }

        public void setLevel3Child(Level3 level3Child) {
            this.level3Child = level3Child;
        }
    }

    @Entity(name="Level1")
    @Indexed
    static class Level1 {
        @Id
        @DocumentId
        private Integer id;
        @OneToOne(mappedBy="level1Parent")
        @IndexedEmbedded
        private DerivedLevel2 derivedLevel2Child;

        Level1() {
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public DerivedLevel2 getDerivedLevel2Child() {
            return this.derivedLevel2Child;
        }

        public void setDerivedLevel2Child(DerivedLevel2 derivedLevel2Child) {
            this.derivedLevel2Child = derivedLevel2Child;
        }
    }
}

