/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.criteria;

import java.util.List;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.query.criteria.AbstractCar;
import org.hibernate.search.test.query.criteria.Bike;
import org.hibernate.search.test.query.criteria.CombiCar;
import org.hibernate.search.test.query.criteria.SportCar;
import org.hibernate.search.testsupport.TestConstants;
import org.junit.Assert;
import org.junit.Test;

public class MixedCriteriaTest
extends SearchTestBase {
    @Test
    public void testCriteriaWithFilteredEntity() throws Exception {
        this.indexTestData();
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"kurztext"}, TestConstants.standardAnalyzer);
        Query query = parser.parse("combi OR sport");
        Criteria criteria = session.createCriteria(AbstractCar.class);
        criteria.add((Criterion)Restrictions.eq((String)"hasColor", (Object)Boolean.FALSE));
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{AbstractCar.class}).setCriteriaQuery(criteria);
        List result = hibQuery.list();
        Assert.assertEquals((long)2L, (long)result.size());
        tx.commit();
        session.close();
    }

    @Test
    public void testCriteriaWithoutFilteredEntity() throws Exception {
        this.indexTestData();
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"kurztext"}, TestConstants.standardAnalyzer);
        Query query = parser.parse("combi OR sport");
        Criteria criteria = session.createCriteria(AbstractCar.class);
        criteria.add((Criterion)Restrictions.eq((String)"hasColor", (Object)Boolean.FALSE));
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[0]).setCriteriaQuery(criteria);
        List result = hibQuery.list();
        Assert.assertEquals((long)2L, (long)result.size());
        tx.commit();
        session.close();
    }

    @Test
    public void testCriteriaWithMultipleEntities() throws Exception {
        this.indexTestData();
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(new String[]{"kurztext"}, TestConstants.standardAnalyzer);
        Query query = parser.parse("combi OR sport");
        Criteria criteria = session.createCriteria(AbstractCar.class);
        criteria.add((Criterion)Restrictions.eq((String)"hasColor", (Object)Boolean.FALSE));
        try {
            FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{AbstractCar.class, Bike.class}).setCriteriaQuery(criteria);
            hibQuery.list();
            Assert.fail();
        }
        catch (SearchException se) {
            Assert.assertEquals((Object)"Cannot mix criteria and multiple entity types", (Object)se.getMessage());
        }
        tx.commit();
        session.close();
    }

    private void indexTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        CombiCar combi = new CombiCar();
        combi.setKurztext("combi");
        s.persist((Object)combi);
        SportCar sport = new SportCar();
        sport.setKurztext("sport");
        s.persist((Object)sport);
        Bike bike = new Bike();
        bike.setKurztext("bike");
        s.persist((Object)bike);
        tx.commit();
        s.close();
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{AbstractCar.class, CombiCar.class, SportCar.class, Bike.class};
    }
}

