/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Date;
import java.util.List;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.bridge.IterableBridgeTestEntity;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IterableBridgeTest
extends SearchTestBase {
    private FullTextSession fullTextSession;
    private IterableBridgeTestEntity withoutNull;
    private IterableBridgeTestEntity withNullEntry;
    private IterableBridgeTestEntity withNullEmbedded;
    private Date indexedDate;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.prepareData();
    }

    private void prepareData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        this.withoutNull = this.persistEntity((Session)this.fullTextSession, "Davide D'Alto");
        this.withoutNull.addNullIndexed(IterableBridgeTestEntity.Language.ITALIAN);
        this.withoutNull.addNullIndexed(IterableBridgeTestEntity.Language.ENGLISH);
        this.withoutNull.addNumericNullIndexed(1);
        this.withoutNull.addNumericNullIndexed(2);
        this.withoutNull.addNullNotIndexed("DaltoValue");
        this.withoutNull.addNullNotIndexed("DavideValue");
        this.withoutNull.addNumericNullNotIndexed(3L);
        this.withoutNull.addNumericNullNotIndexed(4L);
        this.indexedDate = new Date();
        this.withoutNull.addDate(this.indexedDate);
        this.withNullEntry = this.persistEntity((Session)this.fullTextSession, "Worf");
        this.withNullEntry.addNullIndexed(IterableBridgeTestEntity.Language.KLINGON);
        this.withNullEntry.addNullIndexed(IterableBridgeTestEntity.Language.ENGLISH);
        this.withNullEntry.addNullIndexed(null);
        this.withNullEntry.addNumericNullIndexed(11);
        this.withNullEntry.addNumericNullIndexed(null);
        this.withNullEntry.addNullNotIndexed("WorfValue");
        this.withNullEntry.addNullNotIndexed(null);
        this.withNullEntry.addNumericNullNotIndexed(33L);
        this.withNullEntry.addNumericNullNotIndexed(null);
        this.withNullEntry.addDate(null);
        this.withNullEmbedded = this.persistEntity((Session)this.fullTextSession, "Mime");
        this.withNullEmbedded.setDates(null);
        this.withNullEmbedded.setNumericNullIndexed(null);
        this.withNullEmbedded.setNumericNullNotIndexed(null);
        this.withNullEmbedded.setNullIndexed(null);
        this.withNullEmbedded.setNullNotIndexed(null);
        this.withNullEmbedded.setDates(null);
        tx.commit();
    }

    @Test
    public void testSearchNullEntry() throws Exception {
        List<IterableBridgeTestEntity> results = this.findResults("nullIndexed", "NULL_MARKER", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNullNumericEntry() throws Exception {
        List<IterableBridgeTestEntity> results = this.findResults("numericNullIndexed", "-555", true);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Unexpected number of results in a collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNotNullEntry() throws Exception {
        List<IterableBridgeTestEntity> results = this.findResults("nullIndexed", (Object)IterableBridgeTestEntity.Language.KLINGON, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)IterableBridgeTestEntity.Language.ITALIAN, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)IterableBridgeTestEntity.Language.ENGLISH, false);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)2L, (long)results.size());
    }

    @Test
    public void testSearchEntryWhenNullEntryNotIndexed() throws Exception {
        List<IterableBridgeTestEntity> results = this.findResults("nullNotIndexed", "DaltoValue", false);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findResults("nullNotIndexed", "WorfValue", false);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNotNullNumeric() throws Exception {
        List<IterableBridgeTestEntity> results = this.findNumericResults("numericNullIndexed", 1);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findNumericResults("numericNullIndexed", 11);
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed collection", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testSearchNotNullNumericEntryWhenNullEntryNotIndexed() throws Exception {
        List<IterableBridgeTestEntity> results = this.findNumericResults("numericNullNotIndexed", 3L);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
        results = this.findNumericResults("numericNullNotIndexed", 33L);
        Assert.assertNotNull((String)"No result found for an indexed array", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed array", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from an indexed array", (Object)this.withNullEntry.getName(), (Object)results.get(0).getName());
    }

    @Test
    public void testDateIndexing() throws Exception {
        List<IterableBridgeTestEntity> results = this.findResultsWithRangeQuery("dates", DateTools.round((Date)this.indexedDate, (DateTools.Resolution)DateTools.Resolution.SECOND));
        Assert.assertNotNull((String)"No result found for an indexed collection", results);
        Assert.assertEquals((String)"Wrong number of results returned for an indexed collection", (long)1L, (long)results.size());
        Assert.assertEquals((String)"Wrong result returned from a collection of Date", (Object)this.withoutNull.getName(), (Object)results.get(0).getName());
    }

    private List<IterableBridgeTestEntity> findResults(String fieldName, Object value, boolean checkRawValue) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(IterableBridgeTestEntity.class).get();
        TermMatchingContext termMatchingContext = queryBuilder.keyword().onField(fieldName);
        if (checkRawValue) {
            termMatchingContext.ignoreFieldBridge();
            termMatchingContext.ignoreAnalyzer();
        }
        Query query = termMatchingContext.matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{IterableBridgeTestEntity.class}).list();
    }

    private List<IterableBridgeTestEntity> findResultsWithRangeQuery(String fieldName, Object start) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(IterableBridgeTestEntity.class).get();
        Query query = queryBuilder.range().onField(fieldName).above(start).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{IterableBridgeTestEntity.class}).list();
    }

    private List<IterableBridgeTestEntity> findNumericResults(String fieldName, Object number) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)number, (Object)number, (boolean)true, (boolean)true);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{IterableBridgeTestEntity.class}).list();
    }

    private IterableBridgeTestEntity persistEntity(Session s, String name) {
        IterableBridgeTestEntity boy = new IterableBridgeTestEntity();
        boy.setName(name);
        s.persist((Object)boy);
        return boy;
    }

    @Override
    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{IterableBridgeTestEntity.class};
    }
}

