/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.test.configuration.Address;
import org.hibernate.search.test.configuration.Country;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.testing.SkipForDialect;
import org.hibernate.testing.junit4.CustomRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@TestForIssue(jiraKey="HSEARCH-1764")
@SkipForDialect(jiraKey="HSEARCH-1942", value={PostgreSQL81Dialect.class})
@RunWith(value=CustomRunner.class)
public class IndexEmbeddedProgrammaticallyMappedTest {
    @Test
    public void canSetIncludeEmbeddedObjectIdProgrammatically() throws Exception {
        try (FullTextSessionBuilder builder = this.getFullTextSessionBuilder();){
            builder.fluentMapping().entity(Address.class).indexed().property("addressId", ElementType.METHOD).documentId().name("id").property("country", ElementType.METHOD).indexEmbedded().includeEmbeddedObjectId(true);
            Long scotlandCountryId = this.setupTestData(builder);
            FullTextSession s = builder.openFullTextSession();
            QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
            Query luceneQuery = parser.parse("country.id:" + scotlandCountryId);
            Transaction tx = s.beginTransaction();
            FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
            Assert.assertEquals((long)1L, (long)query.getResultSize());
            Assert.assertEquals((Object)"Bob McRobb", (Object)((Address)query.list().iterator().next()).getOwner());
            tx.commit();
            s.close();
        }
    }

    @Test
    public void canSetIndexNullAsProgrammatically() throws Exception {
        try (FullTextSessionBuilder builder = this.getFullTextSessionBuilder();){
            builder.fluentMapping().entity(Address.class).indexed().property("addressId", ElementType.METHOD).documentId().name("id").property("country", ElementType.METHOD).indexEmbedded().indexNullAs("__DEFAULT_NULL_TOKEN__");
            this.setupTestData(builder);
            FullTextSession s = builder.openFullTextSession();
            QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
            Query luceneQuery = parser.parse("country:_null_");
            Transaction tx = s.beginTransaction();
            FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
            Assert.assertEquals((long)1L, (long)query.getResultSize());
            Assert.assertEquals((Object)"Alice Donellis", (Object)((Address)query.list().iterator().next()).getOwner());
            tx.commit();
            s.close();
        }
    }

    @Test
    public void canSetIncludePathsProgrammatically() throws Exception {
        try (FullTextSessionBuilder builder = this.getFullTextSessionBuilder();){
            builder.fluentMapping().entity(Address.class).indexed().property("addressId", ElementType.METHOD).documentId().name("id").property("country", ElementType.METHOD).indexEmbedded().includePaths("id", new String[]{"name"}).entity(Country.class).indexed().property("name", ElementType.METHOD).field();
            Long scotlandCountryId = this.setupTestData(builder);
            FullTextSession s = builder.openFullTextSession();
            QueryParser parser = new QueryParser("id", TestConstants.standardAnalyzer);
            Query luceneQuery = parser.parse("country.id:" + scotlandCountryId);
            Transaction tx = s.beginTransaction();
            FullTextQuery query = s.createFullTextQuery(luceneQuery, new Class[0]);
            Assert.assertEquals((long)1L, (long)query.getResultSize());
            Assert.assertEquals((Object)"Bob McRobb", (Object)((Address)query.list().iterator().next()).getOwner());
            luceneQuery = parser.parse("country.name:Scotland");
            query = s.createFullTextQuery(luceneQuery, new Class[0]);
            Assert.assertEquals((long)1L, (long)query.getResultSize());
            Assert.assertEquals((Object)"Bob McRobb", (Object)((Address)query.list().iterator().next()).getOwner());
            tx.commit();
            s.close();
        }
    }

    private FullTextSessionBuilder getFullTextSessionBuilder() {
        return new FullTextSessionBuilder().addAnnotatedClass(Address.class).addAnnotatedClass(Country.class);
    }

    public Long setupTestData(FullTextSessionBuilder builder) {
        FullTextSession s = builder.openFullTextSession();
        Transaction tx = s.beginTransaction();
        Address bobsPlace = new Address();
        bobsPlace.setOwner("Bob McRobb");
        Address alicesPlace = new Address();
        alicesPlace.setOwner("Alice Donellis");
        Country scotland = new Country();
        scotland.setName("Scotland");
        bobsPlace.setCountry(scotland);
        scotland.getAddresses().add(bobsPlace);
        s.persist((Object)bobsPlace);
        s.persist((Object)alicesPlace);
        s.persist((Object)scotland);
        Long scotlandId = scotland.getId();
        tx.commit();
        s.close();
        return scotlandId;
    }
}

