/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.integration;

import java.util.Collections;
import java.util.HashMap;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.config.internal.ConfigurationServiceImpl;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jndi.spi.JndiService;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostCollectionRecreateEventListener;
import org.hibernate.event.spi.PostCollectionRemoveEventListener;
import org.hibernate.event.spi.PostCollectionUpdateEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.search.bridge.spi.BridgeProvider;
import org.hibernate.search.bridge.spi.IndexManagerTypeSpecificBridgeProvider;
import org.hibernate.search.event.impl.FullTextIndexEventListener;
import org.hibernate.search.hcore.impl.HibernateSearchIntegrator;
import org.hibernate.search.hcore.impl.SearchFactoryReference;
import org.hibernate.search.hcore.spi.BeanResolver;
import org.hibernate.search.hcore.spi.EnvironmentSynchronizer;
import org.hibernate.search.query.engine.impl.LuceneQueryTranslator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.junit.Test;
import org.unitils.UnitilsJUnit4;
import org.unitils.easymock.EasyMockUnitils;
import org.unitils.easymock.annotation.Mock;

public class HibernateSearchIntegratorTest
extends UnitilsJUnit4 {
    private static final Boolean SEARCH_DISABLED = Boolean.FALSE;
    private static final Boolean SEARCH_ENABLED = Boolean.TRUE;
    private static final Boolean SEARCH_IMPLICITLY_ENABLED = null;
    @Mock
    private SessionFactoryServiceRegistry mockSessionFactoryServiceRegistry;
    @Mock
    private SessionFactoryImplementor mockSessionFactoryImplementor;
    @Mock
    private EventListenerRegistry mockEventListenerRegistry;
    @Mock
    private ClassLoaderService mockClassLoaderService;
    @Mock
    private SessionFactoryOptions mockSessionFactoryOptions;
    @Mock
    private JndiService jndiService;
    @Mock
    private Metadata mockMetadata;

    @Test
    public void testEventListenersAreNotRegisteredIfSearchIsExplicitlyDisabledInConfiguration() {
        this.programConfigurationMock(SEARCH_DISABLED);
        EasyMockUnitils.replay();
        new HibernateSearchIntegrator().integrate(null, null, this.mockSessionFactoryServiceRegistry);
    }

    @Test
    public void testEventListenersAreRegisteredIfSearchIsExplicitlyEnabledInConfiguration() {
        this.programConfigurationMock(SEARCH_ENABLED);
        this.assertObserverCalledAndEventListenersRegistered();
    }

    @Test
    public void testEventListenersAreRegisteredIfSearchIsImplicitlyEnabledInConfiguration() {
        this.programConfigurationMock(SEARCH_IMPLICITLY_ENABLED);
        this.assertObserverCalledAndEventListenersRegistered();
    }

    private void assertObserverCalledAndEventListenersRegistered() {
        Capture capturedSessionFactoryObserver = new Capture();
        this.mockSessionFactoryImplementor.addObserver((SessionFactoryObserver)EasyMock.and((Object)EasyMock.capture((Capture)capturedSessionFactoryObserver), (Object)EasyMock.isA(SessionFactoryObserver.class)));
        EasyMock.expect((Object)this.mockSessionFactoryImplementor.getSessionFactoryOptions()).andReturn((Object)this.mockSessionFactoryOptions);
        EasyMock.expect((Object)this.mockSessionFactoryOptions.getMultiTenancyStrategy()).andReturn((Object)MultiTenancyStrategy.NONE);
        EasyMock.expect((Object)this.mockSessionFactoryServiceRegistry.getService(EventListenerRegistry.class)).andReturn((Object)this.mockEventListenerRegistry);
        EasyMock.expect((Object)this.mockSessionFactoryServiceRegistry.getService(SearchFactoryReference.class)).andReturn((Object)new SearchFactoryReference());
        this.mockEventListenerRegistry.addDuplicationStrategy((DuplicationStrategy)EasyMock.isA(HibernateSearchIntegrator.DuplicationStrategyImpl.class));
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_INSERT), (Object[])new PostInsertEventListener[]{(PostInsertEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_UPDATE), (Object[])new PostUpdateEventListener[]{(PostUpdateEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_DELETE), (Object[])new PostDeleteEventListener[]{(PostDeleteEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_COLLECTION_RECREATE), (Object[])new PostCollectionRecreateEventListener[]{(PostCollectionRecreateEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_COLLECTION_REMOVE), (Object[])new PostCollectionRemoveEventListener[]{(PostCollectionRemoveEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.POST_COLLECTION_UPDATE), (Object[])new PostCollectionUpdateEventListener[]{(PostCollectionUpdateEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        this.mockEventListenerRegistry.appendListeners((EventType)EasyMock.eq((Object)EventType.FLUSH), (Object[])new FlushEventListener[]{(FlushEventListener)EasyMock.isA(FullTextIndexEventListener.class)});
        EasyMock.expect((Object)this.mockSessionFactoryServiceRegistry.getService(ClassLoaderService.class)).andReturn((Object)this.mockClassLoaderService).anyTimes();
        EasyMock.expect((Object)this.mockSessionFactoryServiceRegistry.locateServiceBinding(BeanResolver.class)).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.mockSessionFactoryServiceRegistry.locateServiceBinding(EnvironmentSynchronizer.class)).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.mockClassLoaderService.classForName("javax.persistence.Id")).andReturn(Object.class).anyTimes();
        EasyMock.expect((Object)this.mockClassLoaderService.classForName("javax.persistence.EmbeddedId")).andReturn(Object.class).anyTimes();
        EasyMock.expect((Object)this.mockClassLoaderService.loadJavaServices(LuceneQueryTranslator.class)).andReturn(Collections.emptySet());
        EasyMock.expect((Object)this.mockClassLoaderService.loadJavaServices(IndexManagerTypeSpecificBridgeProvider.class)).andReturn(Collections.emptySet());
        EasyMock.expect((Object)this.mockClassLoaderService.loadJavaServices(BridgeProvider.class)).andReturn(Collections.emptySet());
        EasyMock.expect((Object)this.mockClassLoaderService.classForName(EasyMock.startsWith((String)"java.time"))).andThrow((Throwable)new ClassLoadingException("Called by JavaTimeBridgeProvider; we assume the classes in java.time are not on the ORM class loader")).anyTimes();
        EasyMock.expect((Object)this.mockMetadata.getEntityBindings()).andReturn((Object)Collections.EMPTY_SET).anyTimes();
        EasyMock.expect((Object)this.mockSessionFactoryImplementor.getServiceRegistry()).andReturn((Object)this.mockSessionFactoryServiceRegistry).anyTimes();
        EasyMockUnitils.replay();
        HibernateSearchIntegrator testedIntegrator = new HibernateSearchIntegrator();
        testedIntegrator.integrate(this.mockMetadata, this.mockSessionFactoryImplementor, this.mockSessionFactoryServiceRegistry);
        ((SessionFactoryObserver)capturedSessionFactoryObserver.getValue()).sessionFactoryCreated((SessionFactory)this.mockSessionFactoryImplementor);
    }

    private void programConfigurationMock(Boolean enableSearch) {
        HashMap<String, String> settings = new HashMap<String, String>();
        if (enableSearch != null) {
            settings.put("hibernate.search.autoregister_listeners", String.valueOf(enableSearch));
        }
        ConfigurationServiceImpl cfg = new ConfigurationServiceImpl(settings);
        EasyMock.expect((Object)this.mockSessionFactoryServiceRegistry.getService(ConfigurationService.class)).andReturn((Object)cfg).anyTimes();
        EasyMock.expect((Object)this.mockSessionFactoryServiceRegistry.getService(JndiService.class)).andReturn((Object)this.jndiService).anyTimes();
    }
}

