/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.serialization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.test.serialization.RemoteEntity;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.concurrency.ConcurrentRunner;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1637")
public class ConcurrentServiceTest {
    @Rule
    public SearchFactoryHolder searchFactoryHolder = new SearchFactoryHolder(new Class[]{RemoteEntity.class});

    @Test
    public void concurrentSerialization() throws Exception {
        try (final ServiceReference<LuceneWorkSerializer> serializer = this.extractSerializer();){
            ConcurrentRunner runner = new ConcurrentRunner(new ConcurrentRunner.TaskFactory(){

                public Runnable createRunnable(int i) throws Exception {
                    return new SerializingThread((LuceneWorkSerializer)serializer.get(), ConcurrentServiceTest.this.buildLuceneWorkList());
                }
            });
            runner.execute();
        }
    }

    @Test
    public void concurrentDeserialization() throws Exception {
        try (final ServiceReference<LuceneWorkSerializer> serializer = this.extractSerializer();){
            final byte[] serializedModel = ((LuceneWorkSerializer)serializer.get()).toSerializedModel(this.buildLuceneWorkList());
            ConcurrentRunner runner = new ConcurrentRunner(new ConcurrentRunner.TaskFactory(){

                public Runnable createRunnable(int i) throws Exception {
                    return new DeserializingThread((LuceneWorkSerializer)serializer.get(), serializedModel);
                }
            });
            runner.execute();
        }
    }

    private ServiceReference<LuceneWorkSerializer> extractSerializer() {
        return this.searchFactoryHolder.getSearchFactory().getServiceManager().requestReference(LuceneWorkSerializer.class);
    }

    private List<LuceneWork> buildLuceneWorkList() throws Exception {
        ArrayList<LuceneWork> works = new ArrayList<LuceneWork>();
        works.add((LuceneWork)OptimizeLuceneWork.INSTANCE);
        works.add((LuceneWork)OptimizeLuceneWork.INSTANCE);
        works.add((LuceneWork)new OptimizeLuceneWork(RemoteEntity.class));
        works.add((LuceneWork)new PurgeAllLuceneWork(RemoteEntity.class));
        works.add((LuceneWork)new PurgeAllLuceneWork(RemoteEntity.class));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)Long.valueOf(123L), "123", RemoteEntity.class));
        works.add((LuceneWork)new DeleteLuceneWork((Serializable)((Object)"Foo"), "Bar", RemoteEntity.class));
        works.add((LuceneWork)new AddLuceneWork((Serializable)Integer.valueOf(125), "125", RemoteEntity.class, new Document()));
        return works;
    }

    private static class DeserializingThread
    implements Runnable {
        private final LuceneWorkSerializer serializer;
        private final byte[] serializedModel;

        public DeserializingThread(LuceneWorkSerializer serializer, byte[] serializedModel) {
            this.serializer = serializer;
            this.serializedModel = serializedModel;
        }

        @Override
        public void run() {
            List luceneWorks = this.serializer.toLuceneWorks(this.serializedModel);
            Assert.assertEquals((String)"Unexpected count of work instance", (long)8L, (long)luceneWorks.size());
        }
    }

    private static class SerializingThread
    implements Runnable {
        private final LuceneWorkSerializer serializer;
        private final List<LuceneWork> workList;

        public SerializingThread(LuceneWorkSerializer serializer, List<LuceneWork> workList) {
            this.serializer = serializer;
            this.workList = workList;
        }

        @Override
        public void run() {
            byte[] serializedModel = this.serializer.toSerializedModel(this.workList);
            Assert.assertEquals((String)"Unexpected count of work instance", (long)89L, (long)serializedModel.length);
        }
    }
}

