/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.javaserialization.impl;

import java.util.List;
import org.apache.lucene.util.AttributeImpl;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.serialization.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Add;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Delete;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Flush;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Message;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Operation;
import org.hibernate.search.indexes.serialization.javaserialization.impl.OptimizeAll;
import org.hibernate.search.indexes.serialization.javaserialization.impl.PurgeAll;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableBinaryField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableCustomFieldable;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableDocument;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableDoubleField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableFieldable;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableFloatField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableIntField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableLongField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableNumericField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableReaderField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableStringField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableTokenStreamField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Update;
import org.hibernate.search.indexes.serialization.spi.Deserializer;
import org.hibernate.search.indexes.serialization.spi.LuceneWorksBuilder;

public class JavaSerializationDeserializer
implements Deserializer {
    public void deserialize(byte[] data, LuceneWorksBuilder hydrator) {
        Message message = (Message)SerializationHelper.toInstance((byte[])data, Message.class);
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        for (Operation operation : message.getOperations()) {
            Operation safeOperation;
            if (operation instanceof OptimizeAll) {
                hydrator.addOptimizeAll();
                continue;
            }
            if (operation instanceof PurgeAll) {
                safeOperation = (PurgeAll)operation;
                hydrator.addPurgeAllLuceneWork(safeOperation.getClass().getName());
                continue;
            }
            if (operation instanceof Flush) {
                hydrator.addFlush();
                continue;
            }
            if (operation instanceof Delete) {
                safeOperation = (Delete)operation;
                hydrator.addId(((Delete)safeOperation).getId());
                hydrator.addDeleteLuceneWork(((Delete)safeOperation).getEntityClassName(), (ConversionContext)conversionContext);
                continue;
            }
            if (operation instanceof Add) {
                safeOperation = (Add)operation;
                this.buildLuceneDocument(((Add)safeOperation).getDocument(), hydrator);
                hydrator.addId(((Add)safeOperation).getId());
                hydrator.addAddLuceneWork(((Add)safeOperation).getEntityClassName(), ((Add)safeOperation).getFieldToAnalyzerMap(), (ConversionContext)conversionContext);
                continue;
            }
            if (!(operation instanceof Update)) continue;
            safeOperation = (Update)operation;
            this.buildLuceneDocument(((Update)safeOperation).getDocument(), hydrator);
            hydrator.addId(((Update)safeOperation).getId());
            hydrator.addUpdateLuceneWork(((Update)safeOperation).getEntityClassName(), ((Update)safeOperation).getFieldToAnalyzerMap(), (ConversionContext)conversionContext);
        }
    }

    private void buildLuceneDocument(SerializableDocument document, LuceneWorksBuilder hydrator) {
        hydrator.defineDocument();
        for (SerializableFieldable field : document.getFieldables()) {
            SerializableFieldable safeField;
            if (field instanceof SerializableCustomFieldable) {
                safeField = (SerializableCustomFieldable)field;
                hydrator.addFieldable(((SerializableCustomFieldable)safeField).getInstance());
                continue;
            }
            if (field instanceof SerializableNumericField) {
                safeField = (SerializableNumericField)field;
                if (field instanceof SerializableIntField) {
                    hydrator.addIntNumericField(((SerializableIntField)field).getValue(), ((SerializableNumericField)safeField).getName(), ((SerializableNumericField)safeField).getPrecisionStep(), ((SerializableNumericField)safeField).getStore(), ((SerializableNumericField)safeField).isIndexed(), ((SerializableNumericField)safeField).getBoost(), ((SerializableNumericField)safeField).isOmitNorms(), ((SerializableNumericField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableLongField) {
                    hydrator.addLongNumericField(((SerializableLongField)field).getValue(), ((SerializableNumericField)safeField).getName(), ((SerializableNumericField)safeField).getPrecisionStep(), ((SerializableNumericField)safeField).getStore(), ((SerializableNumericField)safeField).isIndexed(), ((SerializableNumericField)safeField).getBoost(), ((SerializableNumericField)safeField).isOmitNorms(), ((SerializableNumericField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableFloatField) {
                    hydrator.addFloatNumericField(((SerializableFloatField)field).getValue(), ((SerializableNumericField)safeField).getName(), ((SerializableNumericField)safeField).getPrecisionStep(), ((SerializableNumericField)safeField).getStore(), ((SerializableNumericField)safeField).isIndexed(), ((SerializableNumericField)safeField).getBoost(), ((SerializableNumericField)safeField).isOmitNorms(), ((SerializableNumericField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableDoubleField) {
                    hydrator.addDoubleNumericField(((SerializableDoubleField)field).getValue(), ((SerializableNumericField)safeField).getName(), ((SerializableNumericField)safeField).getPrecisionStep(), ((SerializableNumericField)safeField).getStore(), ((SerializableNumericField)safeField).isIndexed(), ((SerializableNumericField)safeField).getBoost(), ((SerializableNumericField)safeField).isOmitNorms(), ((SerializableNumericField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                throw new SearchException("Unknown SerializableNumericField: " + field.getClass());
            }
            if (field instanceof SerializableField) {
                SerializableField reallySafeField;
                safeField = (SerializableField)field;
                if (field instanceof SerializableBinaryField) {
                    reallySafeField = (SerializableBinaryField)field;
                    hydrator.addFieldWithBinaryData(reallySafeField.getName(), ((SerializableBinaryField)reallySafeField).getValue(), ((SerializableBinaryField)reallySafeField).getOffset(), ((SerializableBinaryField)reallySafeField).getLength());
                    continue;
                }
                if (field instanceof SerializableStringField) {
                    reallySafeField = (SerializableStringField)field;
                    hydrator.addFieldWithStringData(reallySafeField.getName(), ((SerializableStringField)reallySafeField).getValue(), ((SerializableStringField)reallySafeField).getStore(), ((SerializableStringField)reallySafeField).getIndex(), ((SerializableStringField)reallySafeField).getTermVector(), ((SerializableField)safeField).getBoost(), ((SerializableField)safeField).isOmitNorms(), ((SerializableField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableTokenStreamField) {
                    reallySafeField = (SerializableTokenStreamField)field;
                    List tokens = ((SerializableTokenStreamField)reallySafeField).getValue().getStream();
                    for (List token : tokens) {
                        for (AttributeImpl attribute : token) {
                            hydrator.addAttributeInstance(attribute);
                        }
                        hydrator.addToken();
                    }
                    hydrator.addFieldWithTokenStreamData(reallySafeField.getName(), ((SerializableTokenStreamField)reallySafeField).getTermVector(), ((SerializableField)safeField).getBoost(), ((SerializableField)safeField).isOmitNorms(), ((SerializableField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                if (field instanceof SerializableReaderField) {
                    reallySafeField = (SerializableReaderField)field;
                    hydrator.addFieldWithSerializableReaderData(reallySafeField.getName(), ((SerializableReaderField)reallySafeField).getValue(), ((SerializableReaderField)reallySafeField).getTermVector(), ((SerializableField)safeField).getBoost(), ((SerializableField)safeField).isOmitNorms(), ((SerializableField)safeField).isOmitTermFreqAndPositions());
                    continue;
                }
                throw new SearchException("Unknown SerializableField: " + field.getClass());
            }
            throw new SearchException("Unknown SerializableFieldable: " + field.getClass());
        }
    }
}

