/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.javaserialization.impl;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.serialization.impl.SerializationHelper;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Add;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Delete;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Flush;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Message;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Operation;
import org.hibernate.search.indexes.serialization.javaserialization.impl.OptimizeAll;
import org.hibernate.search.indexes.serialization.javaserialization.impl.PurgeAll;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableBinaryField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableCustomFieldable;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableDocument;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableDoubleField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableFieldable;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableFloatField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableIntField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableLongField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableReaderField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableStringField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableTokenStreamField;
import org.hibernate.search.indexes.serialization.javaserialization.impl.Update;
import org.hibernate.search.indexes.serialization.spi.LuceneFieldContext;
import org.hibernate.search.indexes.serialization.spi.LuceneNumericFieldContext;
import org.hibernate.search.indexes.serialization.spi.Serializer;

public class NativeJavaSerializer
implements Serializer {
    private Serializable id;
    private Set<Operation> ops;
    private Set<SerializableFieldable> serialFields;
    private SerializableDocument currentDocument;

    public void luceneWorks(List<LuceneWork> works) {
        this.ops = new HashSet<Operation>(works.size());
    }

    public void addOptimizeAll() {
        this.ops.add(new OptimizeAll());
    }

    public void addFlush() {
        this.ops.add(new Flush());
    }

    public void addPurgeAll(String entityClassName) {
        this.ops.add(new PurgeAll(entityClassName));
    }

    public void addIdSerializedInJava(byte[] id) {
        this.id = id;
    }

    public void addIdAsInteger(int id) {
        this.id = Integer.valueOf(id);
    }

    public void addIdAsLong(long id) {
        this.id = Long.valueOf(id);
    }

    public void addIdAsFloat(float id) {
        this.id = Float.valueOf(id);
    }

    public void addIdAsDouble(double id) {
        this.id = Double.valueOf(id);
    }

    public void addIdAsString(String id) {
        this.id = id;
    }

    public void addDelete(String entityClassName) {
        this.ops.add(new Delete(entityClassName, this.id));
    }

    public void addAdd(String entityClassName, Map<String, String> fieldToAnalyzerMap) {
        this.ops.add(new Add(entityClassName, this.id, this.currentDocument, fieldToAnalyzerMap));
        this.clearDocument();
    }

    public void addUpdate(String entityClassName, Map<String, String> fieldToAnalyzerMap) {
        this.ops.add(new Update(entityClassName, this.id, this.currentDocument, fieldToAnalyzerMap));
        this.clearDocument();
    }

    public byte[] serialize() {
        Message message = new Message(this.ops);
        return SerializationHelper.toByteArray((Serializable)message);
    }

    public void fields(List<IndexableField> fields) {
        this.serialFields = new HashSet<SerializableFieldable>(fields.size());
    }

    public void addIntNumericField(int value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableIntField(value, context));
    }

    public void addLongNumericField(long value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableLongField(value, context));
    }

    public void addFloatNumericField(float value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableFloatField(value, context));
    }

    public void addDoubleNumericField(double value, LuceneNumericFieldContext context) {
        this.serialFields.add(new SerializableDoubleField(value, context));
    }

    public void addFieldWithBinaryData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableBinaryField(luceneFieldContext));
    }

    public void addFieldWithStringData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableStringField(luceneFieldContext));
    }

    public void addFieldWithTokenStreamData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableTokenStreamField(luceneFieldContext));
    }

    public void addFieldWithSerializableReaderData(LuceneFieldContext luceneFieldContext) {
        this.serialFields.add(new SerializableReaderField(luceneFieldContext));
    }

    public void addFieldWithSerializableFieldable(byte[] fieldable) {
        this.serialFields.add(new SerializableCustomFieldable(fieldable));
    }

    public void addDocument() {
        this.currentDocument = new SerializableDocument(this.serialFields);
    }

    private void clearDocument() {
        this.currentDocument = null;
        this.serialFields = null;
    }
}

