/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.javaserialization.impl;

import org.apache.lucene.util.BytesRef;
import org.hibernate.search.indexes.serialization.javaserialization.impl.SerializableField;
import org.hibernate.search.indexes.serialization.spi.LuceneFieldContext;

public class SerializableBinaryField
extends SerializableField {
    private byte[] value;

    public SerializableBinaryField(LuceneFieldContext context) {
        super(context);
        BytesRef binaryValue = context.getBinaryValue();
        int length = binaryValue.length;
        byte[] extractedBuffer = new byte[length];
        System.arraycopy(binaryValue.bytes, binaryValue.offset, extractedBuffer, 0, length);
        this.value = extractedBuffer;
    }

    public byte[] getValue() {
        return this.value;
    }

    public int getOffset() {
        return 0;
    }

    public int getLength() {
        return this.value.length;
    }
}

