/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.reader;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.hibernate.search.SearchException;
import org.hibernate.search.reader.CacheableMultiReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReaderProviderHelper {
    private static final Field subReadersField = ReaderProviderHelper.getSubReadersField();

    private static Field getSubReadersField() {
        try {
            Field field = MultiReader.class.getDeclaredField("subReaders");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new SearchException("Incompatible version of Lucene: MultiReader.subReaders not available", e);
        }
    }

    public static IndexReader[] getSubReadersFromMultiReader(MultiReader parentReader) {
        try {
            return (IndexReader[])subReadersField.get(parentReader);
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Incompatible version of Lucene: MultiReader.subReaders not accessible", e);
        }
    }

    public static IndexReader buildMultiReader(int length, IndexReader[] readers) {
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            try {
                return new CacheableMultiReader(readers);
            }
            catch (Exception e) {
                ReaderProviderHelper.clean(new SearchException("Unable to open a MultiReader", e), readers);
                return null;
            }
        }
        try {
            return new CacheableMultiReader(readers);
        }
        catch (Exception e) {
            ReaderProviderHelper.clean(new SearchException("Unable to open a MultiReader", e), readers);
            return null;
        }
    }

    public static void clean(SearchException e, IndexReader ... readers) {
        for (IndexReader reader : readers) {
            if (reader == null) continue;
            try {
                reader.close();
            }
            catch (IOException ee) {
                // empty catch block
            }
        }
        throw e;
    }

    public static Set<IndexReader> getIndexReaders(Searchable searchable) {
        HashSet<IndexReader> readers = new HashSet<IndexReader>();
        ReaderProviderHelper.getIndexReadersInternal(readers, searchable);
        return readers;
    }

    public static Set<IndexReader> getIndexReaders(IndexReader reader) {
        HashSet<IndexReader> readers = new HashSet<IndexReader>();
        ReaderProviderHelper.getIndexReadersInternal(readers, reader);
        return readers;
    }

    private static void getIndexReadersInternal(Set<IndexReader> readers, Object obj) {
        if (obj instanceof MultiSearcher) {
            for (Searchable s : ((MultiSearcher)obj).getSearchables()) {
                ReaderProviderHelper.getIndexReadersInternal(readers, s);
            }
        } else if (obj instanceof IndexSearcher) {
            ReaderProviderHelper.getIndexReadersInternal(readers, ((IndexSearcher)obj).getIndexReader());
        } else if (obj instanceof IndexReader) {
            readers.add((IndexReader)obj);
        }
    }
}

