/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.impl.batchlucene.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.batchindexing.ProducerConsumerQueue;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.HibernateHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityConsumerLuceneworkProducer
implements Runnable {
    private static final Logger log = LoggerFactory.make();
    private final ProducerConsumerQueue<List<?>> source;
    private final SessionFactory sessionFactory;
    private final Map<Class<?>, DocumentBuilderIndexedEntity<?>> documentBuilders;
    private final MassIndexerProgressMonitor monitor;
    private final CacheMode cacheMode;
    private final CountDownLatch producerEndSignal;
    private final BatchBackend backend;

    public EntityConsumerLuceneworkProducer(ProducerConsumerQueue<List<?>> entitySource, MassIndexerProgressMonitor monitor, SessionFactory sessionFactory, CountDownLatch producerEndSignal, SearchFactoryImplementor searchFactory, CacheMode cacheMode, BatchBackend backend) {
        this.source = entitySource;
        this.monitor = monitor;
        this.sessionFactory = sessionFactory;
        this.producerEndSignal = producerEndSignal;
        this.cacheMode = cacheMode;
        this.backend = backend;
        this.documentBuilders = searchFactory.getDocumentBuildersIndexedEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        org.hibernate.classic.Session session = this.sessionFactory.openSession();
        session.setFlushMode(FlushMode.MANUAL);
        session.setCacheMode(this.cacheMode);
        session.setDefaultReadOnly(true);
        try {
            Transaction transaction = session.beginTransaction();
            this.indexAllQueue((Session)session);
            transaction.commit();
        }
        catch (Throwable e) {
            log.error("error during batch indexing: ", e);
        }
        finally {
            this.producerEndSignal.countDown();
            session.close();
        }
        log.debug("finished");
    }

    private void indexAllQueue(Session session) {
        try {
            List<?> takeList;
            while ((takeList = this.source.take()) != null) {
                log.trace("received a list of objects to index: {}", takeList);
                for (Object take : takeList) {
                    session.buildLockRequest(LockOptions.NONE).lock(take);
                    this.index(take, session);
                    this.monitor.documentsBuilt(1);
                    session.clear();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void index(Object entity, Session session) throws InterruptedException {
        Serializable id = session.getIdentifier(entity);
        Class<Object> clazz = HibernateHelper.getClass(entity);
        DocumentBuilderIndexedEntity<?> docBuilder = this.documentBuilders.get(clazz);
        TwoWayFieldBridge idBridge = docBuilder.getIdBridge();
        String idInString = idBridge.objectToString(id);
        AddLuceneWork addWork = docBuilder.createAddWork(clazz, entity, id, idInString, true);
        this.backend.enqueueAsyncWork(addWork);
    }
}

