/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.LoaderHelper;
import org.hibernate.search.engine.ObjectLoaderHelper;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.HibernateHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class ObjectLoader
implements Loader {
    private static final Logger log = LoggerFactory.make();
    private Session session;

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor) {
        this.session = session;
    }

    public Object load(EntityInfo entityInfo) {
        return ObjectLoaderHelper.load(entityInfo, this.session);
    }

    public List load(EntityInfo ... entityInfos) {
        if (entityInfos.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (entityInfos.length == 1) {
            Object entity = this.load(entityInfos[0]);
            if (entity == null) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(entity);
            return list;
        }
        for (EntityInfo entityInfo : entityInfos) {
            this.session.load(entityInfo.clazz, entityInfo.id);
        }
        ArrayList<Object> result = new ArrayList<Object>(entityInfos.length);
        for (EntityInfo entityInfo : entityInfos) {
            try {
                Object entity = this.session.load(entityInfo.clazz, entityInfo.id);
                HibernateHelper.initialize(entity);
                result.add(entity);
            }
            catch (RuntimeException e) {
                if (LoaderHelper.isObjectNotFoundException(e)) {
                    log.debug("Object found in Search index but not in database: {} with id {}", (Object)entityInfo.clazz, (Object)entityInfo.id);
                    continue;
                }
                throw e;
            }
        }
        return result;
    }
}

