/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.jmx.HibernateSearchConfigInfoMBean;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSearchConfigInfo
implements HibernateSearchConfigInfoMBean {
    private final SearchFactoryImplementor searchFactoryImplementor;

    public HibernateSearchConfigInfo(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    @Override
    public Set<String> getIndexedClassNames() {
        HashSet<String> indexedClasses = new HashSet<String>();
        for (Class<?> clazz : this.searchFactoryImplementor.getDocumentBuildersIndexedEntities().keySet()) {
            indexedClasses.add(clazz.getName());
        }
        return indexedClasses;
    }

    @Override
    public String getIndexingStrategy() {
        return this.searchFactoryImplementor.getIndexingStrategy();
    }

    @Override
    public int getNumberOfIndexedEntities(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        DirectoryProvider[] directoryProviders = this.searchFactoryImplementor.getDirectoryProviders(clazz);
        ReaderProvider readerProvider = this.searchFactoryImplementor.getReaderProvider();
        int count = 0;
        for (DirectoryProvider directoryProvider : directoryProviders) {
            IndexReader reader = readerProvider.openReader(directoryProvider);
            IndexSearcher searcher = new IndexSearcher(reader);
            BooleanQuery boolQuery = new BooleanQuery();
            boolQuery.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
            boolQuery.add((Query)new TermQuery(new Term("_hibernate_class", entity)), BooleanClause.Occur.MUST);
            try {
                TopDocs topdocs = searcher.search((Query)boolQuery, 1);
                count += topdocs.totalHits;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to execute count query for entity " + entity, e);
            }
            finally {
                readerProvider.closeReader(reader);
            }
        }
        return count;
    }

    @Override
    public Map<String, Integer> indexedEntitiesCount() {
        HashMap<String, Integer> countPerEntity = new HashMap<String, Integer>();
        for (String className : this.getIndexedClassNames()) {
            countPerEntity.put(className, this.getNumberOfIndexedEntities(className));
        }
        return countPerEntity;
    }

    @Override
    public List<String> getIndexingParameters(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        ArrayList<String> indexingParameters = new ArrayList<String>();
        for (DirectoryProvider directoryProvider : this.searchFactoryImplementor.getDirectoryProviders(clazz)) {
            indexingParameters.add(this.searchFactoryImplementor.getIndexingParameters(directoryProvider).toString());
        }
        return indexingParameters;
    }

    private Class<?> getEntityClass(String entity) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName((String)entity, HibernateSearchConfigInfo.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(entity + "not a indexed entity");
        }
        return clazz;
    }
}

