/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jmx;

import java.util.Properties;
import javax.naming.InitialContext;
import org.hibernate.CacheMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.jmx.HibernateSearchIndexCtrlMBean;
import org.hibernate.search.util.JNDIHelper;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSearchIndexCtrl
implements HibernateSearchIndexCtrlMBean {
    private static final String HIBERNATE_JNDI_PREFIX = "hibernate.jndi.";
    private final Properties jndiProperties;
    private final String sessionFactoryJndiName;

    public HibernateSearchIndexCtrl(Properties props) {
        this.sessionFactoryJndiName = props.getProperty("hibernate.session_factory_name");
        this.jndiProperties = JNDIHelper.getJndiProperties(props, HIBERNATE_JNDI_PREFIX);
    }

    @Override
    public void index(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        SessionFactory factory = this.getSessionFactory();
        org.hibernate.classic.Session session = factory.openSession();
        FullTextSession fulltextSession = Search.getFullTextSession((Session)session);
        try {
            fulltextSession.createIndexer(clazz).batchSizeToLoadObjects(25).cacheMode(CacheMode.NORMAL).threadsToLoadObjects(5).threadsForSubsequentFetching(20).startAndWait();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to complete indexing");
        }
        session.close();
    }

    @Override
    public void purge(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        SessionFactory factory = this.getSessionFactory();
        org.hibernate.classic.Session session = factory.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        fullTextSession.beginTransaction();
        fullTextSession.purgeAll(clazz);
        fullTextSession.getTransaction().commit();
        session.close();
    }

    private Class<?> getEntityClass(String entity) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName((String)entity, HibernateSearchIndexCtrl.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(entity + "not a indexed entity");
        }
        return clazz;
    }

    private SessionFactory getSessionFactory() {
        try {
            InitialContext initialContext = this.jndiProperties.isEmpty() ? new InitialContext() : new InitialContext(this.jndiProperties);
            return (SessionFactory)initialContext.lookup(this.sessionFactoryJndiName);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("In order for this operation to work the SessionFactory must be bound to JNDI");
        }
    }
}

