/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.v2.impl;

import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.query.dsl.v2.RangeTerminationExcludable;
import org.hibernate.search.query.dsl.v2.impl.FieldContext;
import org.hibernate.search.query.dsl.v2.impl.Helper;
import org.hibernate.search.query.dsl.v2.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.v2.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.v2.impl.RangeQueryContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectedMultiFieldsRangeQueryBuilder
implements RangeTerminationExcludable {
    private final RangeQueryContext rangeContext;
    private final QueryCustomizer queryCustomizer;
    private final List<FieldContext> fieldContexts;
    private final QueryBuildingContext queryContext;

    public ConnectedMultiFieldsRangeQueryBuilder(RangeQueryContext rangeContext, QueryCustomizer queryCustomizer, List<FieldContext> fieldContexts, QueryBuildingContext queryContext) {
        this.rangeContext = rangeContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldContexts = fieldContexts;
        this.queryContext = queryContext;
    }

    @Override
    public RangeTerminationExcludable excludeLimit() {
        if (this.rangeContext.getFrom() != null && this.rangeContext.getTo() != null) {
            this.rangeContext.setExcludeTo(true);
        } else if (this.rangeContext.getFrom() != null) {
            this.rangeContext.setExcludeTo(true);
        } else if (this.rangeContext.getTo() != null) {
            this.rangeContext.setExcludeTo(true);
        } else {
            throw new AssertionFailure("Both from and to clause of a range query are null");
        }
        return this;
    }

    @Override
    public Query createQuery() {
        int size = this.fieldContexts.size();
        if (size == 1) {
            return this.queryCustomizer.setWrappedQuery(this.createQuery(this.fieldContexts.get(0))).createQuery();
        }
        BooleanQuery aggregatedFieldsQuery = new BooleanQuery();
        for (FieldContext fieldContext : this.fieldContexts) {
            aggregatedFieldsQuery.add(this.createQuery(fieldContext), BooleanClause.Occur.SHOULD);
        }
        return this.queryCustomizer.setWrappedQuery((Query)aggregatedFieldsQuery).createQuery();
    }

    public Query createQuery(FieldContext fieldContext) {
        String fieldName = fieldContext.getField();
        Analyzer queryAnalyzer = this.queryContext.getQueryAnalyzer();
        DocumentBuilderIndexedEntity<?> documentBuilder = Helper.getDocumentBuilder(this.queryContext);
        Object fromObject = this.rangeContext.getFrom();
        String fromString = fieldContext.isIgnoreFieldBridge() ? (fromObject == null ? null : fromObject.toString()) : documentBuilder.objectToString(fieldName, fromObject);
        String lowerTerm = fromString == null ? null : Helper.getAnalyzedTerm(fieldName, fromString, "from", queryAnalyzer, fieldContext);
        Object toObject = this.rangeContext.getTo();
        String toString = fieldContext.isIgnoreFieldBridge() ? (toObject == null ? null : toObject.toString()) : documentBuilder.objectToString(fieldName, toObject);
        String upperTerm = toString == null ? null : Helper.getAnalyzedTerm(fieldName, toString, "to", queryAnalyzer, fieldContext);
        TermRangeQuery perFieldQuery = new TermRangeQuery(fieldName, lowerTerm, upperTerm, !this.rangeContext.isExcludeFrom(), !this.rangeContext.isExcludeTo());
        return fieldContext.getFieldCustomizer().setWrappedQuery((Query)perFieldQuery).createQuery();
    }
}

