/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.QueryTimeoutException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.ParameterMetadata;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.DocumentExtractor;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.ProjectionLoader;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.filter.CachingWrapperFilter;
import org.hibernate.search.filter.ChainedFilter;
import org.hibernate.search.filter.FilterKey;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.filter.StandardFilterKey;
import org.hibernate.search.query.FullTextFilterImpl;
import org.hibernate.search.query.IndexSearcherWithPayload;
import org.hibernate.search.query.IteratorImpl;
import org.hibernate.search.query.ObjectLoaderBuilder;
import org.hibernate.search.query.QueryHits;
import org.hibernate.search.query.ScrollableResultsImpl;
import org.hibernate.search.query.TimeoutManager;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderHelper;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.util.ContextHelper;
import org.hibernate.search.util.FilterCacheModeTypeHelper;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullTextQueryImpl
extends AbstractQueryImpl
implements FullTextQuery {
    private static final Logger log = LoggerFactory.make();
    private final org.apache.lucene.search.Query luceneQuery;
    private Set<Class<?>> indexedTargetedEntities;
    private List<Class<?>> targetedEntities;
    private Set<Class<?>> classesAndSubclasses;
    private boolean needClassFilterClause;
    private Integer firstResult;
    private Integer maxResults;
    private Integer resultSize;
    private Sort sort;
    private Filter filter;
    private Filter userFilter;
    private Criteria criteria;
    private String[] indexProjection;
    private Set<String> idFieldNames;
    private boolean allowFieldSelectionInProjection = true;
    private ResultTransformer resultTransformer;
    private SearchFactoryImplementor searchFactoryImplementor;
    private final Map<String, FullTextFilterImpl> filterDefinitions = new HashMap<String, FullTextFilterImpl>();
    private int fetchSize = 1;
    private static final FullTextFilterImplementor[] EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR = new FullTextFilterImplementor[0];
    private final TimeoutManager timeoutManager;
    private static Loader noLoader = new Loader(){

        public void init(Session session, SearchFactoryImplementor searchFactoryImplementor, TimeoutManager timeoutManager) {
        }

        public Object load(EntityInfo entityInfo) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }

        public Object loadWithoutTiming(EntityInfo entityInfo) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }

        public List load(EntityInfo ... entityInfos) {
            throw new UnsupportedOperationException("noLoader should not be used");
        }
    };

    public FullTextQueryImpl(org.apache.lucene.search.Query query, Class<?>[] classes, SessionImplementor session, ParameterMetadata parameterMetadata) {
        super(query.toString(), null, session, parameterMetadata);
        this.luceneQuery = query;
        this.targetedEntities = Arrays.asList(classes);
        this.searchFactoryImplementor = this.getSearchFactoryImplementor();
        this.indexedTargetedEntities = this.searchFactoryImplementor.getIndexedTypesPolymorphic(classes);
        if (classes != null && classes.length > 0 && this.indexedTargetedEntities.size() == 0) {
            String msg = "None of the specified entity types or any of their subclasses are indexed.";
            throw new IllegalArgumentException(msg);
        }
        this.timeoutManager = new TimeoutManager();
    }

    @Override
    public FullTextQuery setSort(Sort sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public FullTextQuery setFilter(Filter filter) {
        this.userFilter = filter;
        return this;
    }

    public Iterator iterate() throws HibernateException {
        this.timeoutManager.start(this.luceneQuery);
        IndexSearcherWithPayload searcher = this.buildSearcher(this.searchFactoryImplementor);
        if (searcher == null) {
            return new IteratorImpl(Collections.EMPTY_LIST, noLoader);
        }
        try {
            QueryHits queryHits = this.getQueryHits(searcher, this.calculateTopDocsRetrievalSize());
            int first = this.first();
            int max = this.max(first, queryHits.totalHits);
            int size = max - first + 1 < 0 ? 0 : max - first + 1;
            ArrayList<EntityInfo> infos = new ArrayList<EntityInfo>(size);
            DocumentExtractor extractor = new DocumentExtractor(queryHits, this.searchFactoryImplementor, this.indexProjection, this.idFieldNames, this.allowFieldSelectionInProjection);
            try {
                for (int index = first; index <= max; ++index) {
                    infos.add(extractor.extract(index));
                    if (index % 10 != 0) continue;
                    this.timeoutManager.isTimedOut();
                }
            }
            catch (QueryTimeoutException e) {
                this.reactOnQueryTimeoutExceptionWhileExtracting(e);
            }
            Loader loader = this.getLoader();
            this.timeoutManager.stop();
            IteratorImpl iteratorImpl = new IteratorImpl(infos, loader);
            return iteratorImpl;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
        finally {
            try {
                this.closeSearcher((Searcher)searcher.getSearcher(), this.searchFactoryImplementor.getReaderProvider());
            }
            catch (SearchException e) {
                log.warn("Unable to properly close searcher during lucene query: " + this.getQueryString(), (Throwable)e);
            }
        }
    }

    private void reactOnQueryTimeoutExceptionWhileExtracting(QueryTimeoutException e) {
        this.timeoutManager.reactOnQueryTimeoutExceptionWhileExtracting(e);
    }

    private Loader getLoader() {
        ObjectLoaderBuilder loaderBuilder = new ObjectLoaderBuilder().criteria(this.criteria).targetedEntities(this.targetedEntities).indexedTargetedEntities(this.indexedTargetedEntities).session(this.session).searchFactory(this.searchFactoryImplementor).timeoutManager(this.timeoutManager);
        if (this.indexProjection != null) {
            return this.getProjectionLoader(loaderBuilder);
        }
        return loaderBuilder.buildLoader();
    }

    private Loader getProjectionLoader(ObjectLoaderBuilder loaderBuilder) {
        ProjectionLoader loader = new ProjectionLoader();
        loader.init((Session)this.session, this.searchFactoryImplementor, this.resultTransformer, loaderBuilder, this.indexProjection, this.timeoutManager);
        return loader;
    }

    public ScrollableResults scroll() throws HibernateException {
        this.timeoutManager.start(this.luceneQuery);
        IndexSearcherWithPayload searcher = this.buildSearcher(this.searchFactoryImplementor);
        try {
            QueryHits queryHits = this.getQueryHits(searcher, this.calculateTopDocsRetrievalSize());
            int first = this.first();
            int max = this.max(first, queryHits.totalHits);
            DocumentExtractor extractor = new DocumentExtractor(queryHits, this.searchFactoryImplementor, this.indexProjection, this.idFieldNames, this.allowFieldSelectionInProjection);
            Loader loader = this.getLoader();
            this.timeoutManager.stop();
            return new ScrollableResultsImpl(searcher.getSearcher(), first, max, this.fetchSize, extractor, loader, this.searchFactoryImplementor, this.session);
        }
        catch (IOException e) {
            try {
                this.closeSearcher((Searcher)searcher.getSearcher(), this.searchFactoryImplementor.getReaderProvider());
            }
            catch (SearchException searchException) {
                // empty catch block
            }
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
    }

    public ScrollableResults scroll(ScrollMode scrollMode) throws HibernateException {
        return this.scroll();
    }

    public List list() throws HibernateException {
        this.timeoutManager.start(this.luceneQuery);
        IndexSearcherWithPayload searcher = this.buildSearcher(this.searchFactoryImplementor);
        if (searcher == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            QueryHits queryHits = this.getQueryHits(searcher, this.calculateTopDocsRetrievalSize());
            int first = this.first();
            int max = this.max(first, queryHits.totalHits);
            int size = max - first + 1 < 0 ? 0 : max - first + 1;
            ArrayList<EntityInfo> infos = new ArrayList<EntityInfo>(size);
            DocumentExtractor extractor = new DocumentExtractor(queryHits, this.searchFactoryImplementor, this.indexProjection, this.idFieldNames, this.allowFieldSelectionInProjection);
            try {
                for (int index = first; index <= max; ++index) {
                    infos.add(extractor.extract(index));
                    if (index % 10 != 0) continue;
                    this.timeoutManager.isTimedOut();
                }
            }
            catch (QueryTimeoutException e) {
                this.reactOnQueryTimeoutExceptionWhileExtracting(e);
            }
            Loader loader = this.getLoader();
            List list = loader.load(infos.toArray(new EntityInfo[infos.size()]));
            if (this.resultTransformer == null || loader instanceof ProjectionLoader) {
                List list2 = list;
                return list2;
            }
            List list3 = this.resultTransformer.transformList(list);
            return list3;
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index", (Throwable)e);
        }
        finally {
            try {
                this.closeSearcher((Searcher)searcher.getSearcher(), this.searchFactoryImplementor.getReaderProvider());
            }
            catch (SearchException e) {
                log.warn("Unable to properly close searcher during lucene query: " + this.getQueryString(), (Throwable)e);
            }
        }
    }

    @Override
    public Explanation explain(int documentId) {
        Explanation explanation = null;
        IndexSearcherWithPayload searcher = this.buildSearcher(this.searchFactoryImplementor, true);
        if (searcher == null) {
            throw new SearchException("Unable to build explanation for document id:" + documentId + ". no index found");
        }
        try {
            org.apache.lucene.search.Query query = this.filterQueryByClasses(this.luceneQuery);
            this.buildFilters();
            explanation = searcher.getSearcher().explain(query, documentId);
        }
        catch (IOException e) {
            throw new HibernateException("Unable to query Lucene index and build explanation", (Throwable)e);
        }
        finally {
            try {
                this.closeSearcher((Searcher)searcher.getSearcher(), this.searchFactoryImplementor.getReaderProvider());
            }
            catch (SearchException e) {
                log.warn("Unable to properly close searcher during lucene query: " + this.getQueryString(), (Throwable)e);
            }
        }
        return explanation;
    }

    private QueryHits getQueryHits(IndexSearcherWithPayload searcher, Integer n) throws IOException {
        org.apache.lucene.search.Query query = this.filterQueryByClasses(this.luceneQuery);
        this.buildFilters();
        boolean stats = this.searchFactoryImplementor.getStatistics().isStatisticsEnabled();
        long startTime = 0L;
        if (stats) {
            startTime = System.nanoTime();
        }
        QueryHits queryHits = n == null ? new QueryHits(searcher, query, this.filter, this.sort, this.timeoutManager) : new QueryHits(searcher, query, this.filter, this.sort, n, this.timeoutManager);
        this.resultSize = queryHits.totalHits;
        if (stats) {
            this.searchFactoryImplementor.getStatisticsImplementor().searchExecuted(query.toString(), System.nanoTime() - startTime);
        }
        return queryHits;
    }

    private Integer calculateTopDocsRetrievalSize() {
        if (this.maxResults == null) {
            return null;
        }
        long tmpMaxResult = (long)this.first() + (long)this.maxResults.intValue();
        if (tmpMaxResult >= Integer.MAX_VALUE) {
            return 0x7FFFFFFE;
        }
        if (tmpMaxResult == 0L) {
            return 1;
        }
        return (int)tmpMaxResult;
    }

    private void buildFilters() {
        ChainedFilter chainedFilter = null;
        if (!this.filterDefinitions.isEmpty()) {
            chainedFilter = new ChainedFilter();
            for (FullTextFilterImpl fullTextFilter : this.filterDefinitions.values()) {
                Filter filter = this.buildLuceneFilter(fullTextFilter);
                if (filter == null) continue;
                chainedFilter.addFilter(filter);
            }
        }
        if (this.userFilter != null) {
            if (chainedFilter == null) {
                chainedFilter = new ChainedFilter();
            }
            chainedFilter.addFilter(this.userFilter);
        }
        this.filter = chainedFilter == null || chainedFilter.isEmpty() ? null : chainedFilter;
    }

    private Filter buildLuceneFilter(FullTextFilterImpl fullTextFilter) {
        Filter filter;
        FilterDef def = this.searchFactoryImplementor.getFilterDefinition(fullTextFilter.getName());
        if (this.isPreQueryFilterOnly(def)) {
            return null;
        }
        Object instance = this.createFilterInstance(fullTextFilter, def);
        FilterKey key = this.createFilterKey(def, instance);
        Filter filter2 = filter = FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode()) ? this.searchFactoryImplementor.getFilterCachingStrategy().getCachedFilter(key) : null;
        if (filter == null) {
            filter = this.createFilter(def, instance);
            if (FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode())) {
                this.searchFactoryImplementor.getFilterCachingStrategy().addCachedFilter(key, filter);
            }
        }
        return filter;
    }

    private boolean isPreQueryFilterOnly(FilterDef def) {
        return def.getImpl().equals(ShardSensitiveOnlyFilter.class);
    }

    private Filter createFilter(FilterDef def, Object instance) {
        Filter filter;
        if (def.getFactoryMethod() != null) {
            try {
                filter = (Filter)def.getFactoryMethod().invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new SearchException("Unable to access @Factory method: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return a org.apache.lucene.search.Filter class: " + def.getImpl().getName() + "." + def.getFactoryMethod().getName(), e);
            }
        }
        try {
            filter = (Filter)instance;
        }
        catch (ClassCastException e) {
            throw new SearchException("Filter implementation does not implement the Filter interface: " + def.getImpl().getName() + ". " + (def.getFactoryMethod() != null ? def.getFactoryMethod().getName() : ""), e);
        }
        filter = this.addCachingWrapperFilter(filter, def);
        return filter;
    }

    private Filter addCachingWrapperFilter(Filter filter, FilterDef def) {
        if (FilterCacheModeTypeHelper.cacheResults(def.getCacheMode())) {
            int cachingWrapperFilterSize = this.searchFactoryImplementor.getFilterCacheBitResultsSize();
            filter = new CachingWrapperFilter(filter, cachingWrapperFilterSize);
        }
        return filter;
    }

    private FilterKey createFilterKey(FilterDef def, Object instance) {
        FilterKey key = null;
        if (!FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode())) {
            return key;
        }
        if (def.getKeyMethod() == null) {
            key = new FilterKey(){

                public int hashCode() {
                    return this.getImpl().hashCode();
                }

                public boolean equals(Object obj) {
                    if (!(obj instanceof FilterKey)) {
                        return false;
                    }
                    FilterKey that = (FilterKey)obj;
                    return this.getImpl().equals(that.getImpl());
                }
            };
        } else {
            try {
                key = (FilterKey)def.getKeyMethod().invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (InvocationTargetException e) {
                throw new SearchException("Unable to access @Key method: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
            catch (ClassCastException e) {
                throw new SearchException("@Key method does not return FilterKey: " + def.getImpl().getName() + "." + def.getKeyMethod().getName());
            }
        }
        key.setImpl(def.getImpl());
        StandardFilterKey wrapperKey = new StandardFilterKey();
        wrapperKey.addParameter(def.getName());
        wrapperKey.addParameter(key);
        return wrapperKey;
    }

    private Object createFilterInstance(FullTextFilterImpl fullTextFilter, FilterDef def) {
        Object instance;
        try {
            instance = def.getImpl().newInstance();
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), e);
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create @FullTextFilterDef: " + def.getImpl(), e);
        }
        for (Map.Entry<String, Object> entry : fullTextFilter.getParameters().entrySet()) {
            def.invoke(entry.getKey(), instance, entry.getValue());
        }
        if (FilterCacheModeTypeHelper.cacheInstance(def.getCacheMode()) && def.getKeyMethod() == null && fullTextFilter.getParameters().size() > 0) {
            throw new SearchException("Filter with parameters and no @Key method: " + fullTextFilter.getName());
        }
        return instance;
    }

    private org.apache.lucene.search.Query filterQueryByClasses(org.apache.lucene.search.Query luceneQuery) {
        if (!this.needClassFilterClause) {
            return luceneQuery;
        }
        BooleanQuery classFilter = new BooleanQuery();
        classFilter.setBoost(0.0f);
        for (Class<?> clazz : this.classesAndSubclasses) {
            Term t = new Term("_hibernate_class", clazz.getName());
            TermQuery termQuery = new TermQuery(t);
            classFilter.add((org.apache.lucene.search.Query)termQuery, BooleanClause.Occur.SHOULD);
        }
        BooleanQuery filteredQuery = new BooleanQuery();
        filteredQuery.add(luceneQuery, BooleanClause.Occur.MUST);
        filteredQuery.add((org.apache.lucene.search.Query)classFilter, BooleanClause.Occur.MUST);
        return filteredQuery;
    }

    private int max(int first, int totalHits) {
        if (this.maxResults == null) {
            return totalHits - 1;
        }
        return this.maxResults + first < totalHits ? first + this.maxResults - 1 : totalHits - 1;
    }

    private int first() {
        return this.firstResult != null ? this.firstResult : 0;
    }

    private IndexSearcherWithPayload buildSearcher(SearchFactoryImplementor searchFactoryImplementor) {
        return this.buildSearcher(searchFactoryImplementor, null);
    }

    private IndexSearcherWithPayload buildSearcher(SearchFactoryImplementor searchFactoryImplementor, Boolean forceScoring) {
        Map<Class<?>, DocumentBuilderIndexedEntity<?>> builders = searchFactoryImplementor.getDocumentBuildersIndexedEntities();
        ArrayList<DirectoryProvider> targetedDirectories = new ArrayList<DirectoryProvider>();
        HashSet<String> idFieldNames = new HashSet<String>();
        Similarity searcherSimilarity = null;
        if (this.indexedTargetedEntities.size() == 0) {
            if (builders.isEmpty()) {
                throw new HibernateException("There are no mapped entities. Don't forget to add @Indexed to at least one class.");
            }
            for (DocumentBuilderIndexedEntity<?> builder : builders.values()) {
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, builder);
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                this.populateDirectories(targetedDirectories, builder);
            }
            this.classesAndSubclasses = null;
        } else {
            DocumentBuilderIndexedEntity<?> builder;
            HashSet involvedClasses = new HashSet(this.indexedTargetedEntities.size());
            involvedClasses.addAll(this.indexedTargetedEntities);
            for (Class<Object> clazz : this.indexedTargetedEntities) {
                builder = builders.get(clazz);
                if (builder == null) continue;
                involvedClasses.addAll(builder.getMappedSubclasses());
            }
            for (Class<Object> clazz : involvedClasses) {
                builder = builders.get(clazz);
                if (builder == null) {
                    throw new HibernateException("Not a mapped entity (don't forget to add @Indexed): " + clazz);
                }
                if (builder.getIdKeywordName() != null) {
                    idFieldNames.add(builder.getIdKeywordName());
                    this.allowFieldSelectionInProjection = this.allowFieldSelectionInProjection && builder.allowFieldSelectionInProjection();
                }
                searcherSimilarity = this.checkSimilarity(searcherSimilarity, builder);
                this.populateDirectories(targetedDirectories, builder);
            }
            this.classesAndSubclasses = involvedClasses;
        }
        this.idFieldNames = idFieldNames;
        if (this.classesAndSubclasses != null) {
            for (DirectoryProvider dp : targetedDirectories) {
                Set<Class<?>> classesInDirectoryProvider = searchFactoryImplementor.getClassesInDirectoryProvider(dp);
                if (classesInDirectoryProvider.size() > 1) {
                    for (Class<?> clazz : classesInDirectoryProvider) {
                        if (this.classesAndSubclasses.contains(clazz)) continue;
                        this.needClassFilterClause = true;
                        break;
                    }
                }
                if (!this.needClassFilterClause) continue;
                break;
            }
        }
        DirectoryProvider[] directoryProviders = targetedDirectories.toArray(new DirectoryProvider[targetedDirectories.size()]);
        IndexSearcher is = new IndexSearcher(searchFactoryImplementor.getReaderProvider().openReader(directoryProviders));
        is.setSimilarity(searcherSimilarity);
        String[] projection = this.indexProjection;
        if (Boolean.TRUE.equals(forceScoring)) {
            return new IndexSearcherWithPayload(is, true, true);
        }
        if (Boolean.FALSE.equals(forceScoring)) {
            return new IndexSearcherWithPayload(is, false, false);
        }
        if (this.sort != null && projection != null) {
            boolean activate = false;
            for (String field : projection) {
                if (!"__HSearch_Score".equals(field)) continue;
                activate = true;
                break;
            }
            if (activate) {
                return new IndexSearcherWithPayload(is, true, false);
            }
        }
        return new IndexSearcherWithPayload(is, false, false);
    }

    private void populateDirectories(List<DirectoryProvider> directories, DocumentBuilderIndexedEntity builder) {
        IndexShardingStrategy indexShardingStrategy = builder.getDirectoryProviderSelectionStrategy();
        DirectoryProvider<?>[] directoryProviders = this.filterDefinitions != null && !this.filterDefinitions.isEmpty() ? indexShardingStrategy.getDirectoryProvidersForQuery(this.filterDefinitions.values().toArray(new FullTextFilterImplementor[this.filterDefinitions.size()])) : indexShardingStrategy.getDirectoryProvidersForQuery(EMPTY_FULL_TEXT_FILTER_IMPLEMENTOR);
        for (DirectoryProvider<?> provider : directoryProviders) {
            if (directories.contains(provider)) continue;
            directories.add(provider);
        }
    }

    private Similarity checkSimilarity(Similarity similarity, DocumentBuilderIndexedEntity builder) {
        if (similarity == null) {
            similarity = builder.getSimilarity();
        } else if (!similarity.getClass().equals(builder.getSimilarity().getClass())) {
            throw new HibernateException("Cannot perform search on two entities with differing Similarity implementations (" + similarity.getClass().getName() + " & " + builder.getSimilarity().getClass().getName() + ")");
        }
        return similarity;
    }

    private void closeSearcher(Searcher searcher, ReaderProvider readerProvider) {
        Set<IndexReader> indexReaders = ReaderProviderHelper.getIndexReaders((Searchable)searcher);
        for (IndexReader indexReader : indexReaders) {
            readerProvider.closeReader(indexReader);
        }
    }

    @Override
    public int getResultSize() {
        if (this.resultSize == null) {
            this.timeoutManager.start(this.luceneQuery);
            IndexSearcherWithPayload searcher = this.buildSearcher(this.searchFactoryImplementor, false);
            if (searcher == null) {
                this.resultSize = 0;
            } else {
                try {
                    TopDocs hits = this.getQueryHits((IndexSearcherWithPayload)searcher, (Integer)Integer.valueOf((int)1)).topDocs;
                    this.resultSize = hits.totalHits;
                }
                catch (IOException e) {
                    throw new HibernateException("Unable to query Lucene index", (Throwable)e);
                }
                finally {
                    try {
                        this.closeSearcher((Searcher)searcher.getSearcher(), this.searchFactoryImplementor.getReaderProvider());
                    }
                    catch (SearchException e) {
                        log.warn("Unable to properly close searcher during lucene query: " + this.getQueryString(), (Throwable)e);
                    }
                }
            }
        }
        return this.resultSize;
    }

    @Override
    public FullTextQuery setCriteriaQuery(Criteria criteria) {
        this.criteria = criteria;
        return this;
    }

    @Override
    public FullTextQuery setProjection(String ... fields) {
        this.indexProjection = fields == null || fields.length == 0 ? null : fields;
        return this;
    }

    @Override
    public FullTextQuery setFirstResult(int firstResult) {
        if (firstResult < 0) {
            throw new IllegalArgumentException("'first' pagination parameter less than 0");
        }
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public FullTextQuery setMaxResults(int maxResults) {
        if (maxResults < 0) {
            throw new IllegalArgumentException("'max' pagination parameter less than 0");
        }
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public FullTextQuery setFetchSize(int fetchSize) {
        super.setFetchSize(fetchSize);
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("'fetch size' parameter less than or equals to 0");
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public Query setLockOptions(LockOptions lockOptions) {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    @Override
    public FullTextQuery setResultTransformer(ResultTransformer transformer) {
        super.setResultTransformer(transformer);
        this.resultTransformer = transformer;
        return this;
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (type == org.apache.lucene.search.Query.class) {
            return (T)this.luceneQuery;
        }
        throw new IllegalArgumentException("Cannot unwrap " + type.getName());
    }

    public LockOptions getLockOptions() {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    public int executeUpdate() throws HibernateException {
        throw new UnsupportedOperationException("executeUpdate is not supported in Hibernate Search queries");
    }

    public Query setLockMode(String alias, LockMode lockMode) {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    protected Map getLockModes() {
        throw new UnsupportedOperationException("Lock options are not implemented in Hibernate Search queries");
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        FullTextFilterImpl filterDefinition = this.filterDefinitions.get(name);
        if (filterDefinition != null) {
            return filterDefinition;
        }
        filterDefinition = new FullTextFilterImpl();
        filterDefinition.setName(name);
        FilterDef filterDef = this.searchFactoryImplementor.getFilterDefinition(name);
        if (filterDef == null) {
            throw new SearchException("Unkown @FullTextFilter: " + name);
        }
        this.filterDefinitions.put(name, filterDefinition);
        return filterDefinition;
    }

    @Override
    public void disableFullTextFilter(String name) {
        this.filterDefinitions.remove(name);
    }

    public FullTextQuery setTimeout(int timeout) {
        return this.setTimeout(timeout, TimeUnit.SECONDS);
    }

    @Override
    public FullTextQuery setTimeout(long timeout, TimeUnit timeUnit) {
        super.setTimeout((int)timeUnit.toSeconds(timeout));
        this.timeoutManager.setTimeout(timeout, timeUnit);
        this.timeoutManager.raiseExceptionOnTimeout();
        return this;
    }

    @Override
    public FullTextQuery limitFetchingTime(long timeout, TimeUnit timeUnit) {
        this.timeoutManager.setTimeout(timeout, timeUnit);
        this.timeoutManager.limitFetchingOnTimeout();
        return this;
    }

    @Override
    public boolean hasPartialResults() {
        return this.timeoutManager.hasPartialResults();
    }

    private SearchFactoryImplementor getSearchFactoryImplementor() {
        if (this.searchFactoryImplementor == null) {
            this.searchFactoryImplementor = ContextHelper.getSearchFactoryBySFI(this.session);
        }
        return this.searchFactoryImplementor;
    }
}

