/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.query.dsl.QueryCustomization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryCustomizer
implements QueryCustomization<QueryCustomizer> {
    private float boost = 1.0f;
    private boolean constantScore;
    private Query wrappedQuery;
    private Filter filter;

    QueryCustomizer() {
    }

    @Override
    public QueryCustomizer boostedTo(float boost) {
        this.boost = boost * this.boost;
        return this;
    }

    @Override
    public QueryCustomizer withConstantScore() {
        this.constantScore = true;
        return this;
    }

    @Override
    public QueryCustomizer filteredBy(Filter filter) {
        this.filter = filter;
        return this;
    }

    public QueryCustomizer setWrappedQuery(Query wrappedQuery) {
        this.wrappedQuery = wrappedQuery;
        return this;
    }

    public Query createQuery() {
        Query finalQuery = this.wrappedQuery;
        if (this.wrappedQuery == null) {
            throw new AssertionFailure("wrapped query not set");
        }
        finalQuery.setBoost(this.boost * finalQuery.getBoost());
        if (this.filter != null) {
            finalQuery = new FilteredQuery(finalQuery, this.filter);
        }
        if (this.constantScore) {
            finalQuery = new ConstantScoreQuery((Filter)new QueryWrapperFilter(finalQuery));
        }
        return finalQuery;
    }
}

