/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.impl.SessionFactoryImpl;
import org.hibernate.jdbc.Work;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.event.FullTextIndexEventListener;
import org.hibernate.search.test.util.JGroupsEnvironment;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.testing.junit.functional.annotations.HibernateTestCase;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SearchTestCase
extends HibernateTestCase {
    private static final Logger log = LoggerFactory.make();
    public static final Analyzer standardAnalyzer = new StandardAnalyzer(SearchTestCase.getTargetLuceneVersion());
    public static final Analyzer stopAnalyzer = new StopAnalyzer(SearchTestCase.getTargetLuceneVersion());
    public static final Analyzer simpleAnalyzer = new SimpleAnalyzer();
    public static final Analyzer keywordAnalyzer = new KeywordAnalyzer();
    protected static final File indexDir;
    protected static SessionFactory sessions;
    protected Session session;
    private static File targetDir;
    private SearchFactoryImplementor searchFactory;

    public SearchTestCase() {
    }

    public SearchTestCase(String x) {
        super(x);
    }

    protected void handleUnclosedResources() {
        if (this.session != null && this.session.isOpen()) {
            if (this.session.isConnected()) {
                this.session.doWork((Work)new HibernateTestCase.RollbackWork((HibernateTestCase)this));
            }
            this.session.close();
            this.session = null;
            log.warn("Closing open session. Make sure to close sessions explicitly in your tests!");
        } else {
            this.session = null;
        }
    }

    protected void closeResources() {
    }

    public Session openSession() throws HibernateException {
        this.session = this.getSessions().openSession();
        return this.session;
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        this.session = this.getSessions().openSession(interceptor);
        return this.session;
    }

    protected void setSessions(SessionFactory sessions) {
        SearchTestCase.sessions = sessions;
    }

    protected SessionFactory getSessions() {
        return sessions;
    }

    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.directory_provider", "ram");
        cfg.setProperty("hibernate.search.default.indexBase", indexDir.getAbsolutePath());
        cfg.setProperty("hibernate.search.analyzer", StopAnalyzer.class.getName());
        cfg.setProperty("hibernate.search.default.transaction.merge_factor", "100");
        cfg.setProperty("hibernate.search.default.batch.max_buffered_docs", "1000");
    }

    protected Directory getDirectory(Class<?> clazz) {
        return this.getLuceneEventListener().getSearchFactoryImplementor().getDirectoryProviders(clazz)[0].getDirectory();
    }

    private FullTextIndexEventListener getLuceneEventListener() {
        PostInsertEventListener[] listeners = ((SessionFactoryImpl)this.getSessions()).getEventListeners().getPostInsertEventListeners();
        FullTextIndexEventListener listener = null;
        for (PostInsertEventListener candidate : listeners) {
            if (!(candidate instanceof FullTextIndexEventListener)) continue;
            listener = (FullTextIndexEventListener)candidate;
            break;
        }
        if (listener == null) {
            throw new HibernateException("Lucene event listener not initialized");
        }
        return listener;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.ensureIndexesAreEmpty();
    }

    protected void ensureIndexesAreEmpty() {
        if ("jms".equals(SearchTestCase.getCfg().getProperty("hibernate.search.worker.backend"))) {
            log.debug("JMS based test. Skipping index emptying");
            return;
        }
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = s.beginTransaction();
        for (Class clazz : this.getAnnotatedClasses()) {
            if (clazz.getAnnotation(Indexed.class) == null) continue;
            s.purgeAll(clazz);
        }
        tx.commit();
        s.close();
    }

    protected SearchFactory getSearchFactory() {
        if (this.searchFactory == null) {
            Session session = this.openSession();
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            this.searchFactory = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
            fullTextSession.close();
        }
        return this.searchFactory;
    }

    protected File getBaseIndexDir() {
        return indexDir;
    }

    protected void buildConfiguration() throws Exception {
        if (this.getSessions() != null) {
            this.getSessions().close();
        }
        try {
            SearchTestCase.setCfg((Configuration)new Configuration());
            this.configure(cfg);
            if (this.recreateSchema()) {
                cfg.setProperty("hibernate.hbm2ddl.auto", "create-drop");
            }
            for (String aPackage : this.getAnnotatedPackages()) {
                SearchTestCase.getCfg().addPackage(aPackage);
            }
            for (Class aClass : this.getAnnotatedClasses()) {
                SearchTestCase.getCfg().addAnnotatedClass(aClass);
            }
            for (String xmlFile : this.getXmlFiles()) {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);
                SearchTestCase.getCfg().addInputStream(is);
            }
            this.setSessions(SearchTestCase.getCfg().buildSessionFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected String[] getAnnotatedPackages() {
        return new String[0];
    }

    public static Version getTargetLuceneVersion() {
        return Version.LUCENE_29;
    }

    protected SearchFactoryImplementor getSearchFactoryImpl() {
        FullTextSession s = Search.getFullTextSession((Session)this.openSession());
        s.close();
        SearchFactory searchFactory = s.getSearchFactory();
        return (SearchFactoryImplementor)searchFactory;
    }

    public static File getTargetDir() {
        return targetDir;
    }

    static {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URL myUrl = contextClassLoader.getResource(SearchTestCase.class.getName().replace('.', '/') + ".class");
        File myPath = new File(myUrl.getFile());
        targetDir = myPath.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile();
        indexDir = new File(targetDir, "indextemp");
        log.debug("Using {} as index directory.", (Object)indexDir.getAbsolutePath());
        JGroupsEnvironment.initJGroupsProperties();
    }
}

