/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration.mutablefactory;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.batchindexing.Executors;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.configuration.mutablefactory.A;
import org.hibernate.search.test.configuration.mutablefactory.B;
import org.hibernate.search.test.configuration.mutablefactory.C;
import org.hibernate.search.test.configuration.mutablefactory.generated.Generated;
import org.hibernate.search.test.util.ManualConfiguration;
import org.hibernate.search.test.util.ManualTransactionContext;
import org.hibernate.search.util.FileHelper;
import org.hibernate.search.util.LoggerFactory;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableFactoryTest {
    public static final Logger log = LoggerFactory.make();

    @Test
    public void testCreateEmptyFactory() throws Exception {
        ManualConfiguration configuration = new ManualConfiguration();
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        sf.close();
    }

    @Test
    public void testAddingClassFullModel() throws Exception {
        ManualConfiguration configuration = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram");
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        SearchFactoryBuilder builder = new SearchFactoryBuilder();
        sf = builder.currentFactory((SearchFactoryIntegrator)sf).addClass(A.class).buildSearchFactory();
        ManualTransactionContext tc = new ManualTransactionContext();
        MutableFactoryTest.doIndexWork(new A(1, "Emmanuel"), 1, (SearchFactoryIntegrator)sf, tc);
        tc.end();
        QueryParser parser = new QueryParser(SearchTestCase.getTargetLuceneVersion(), "name", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("Emmanuel");
        DirectoryProvider provider = sf.getDirectoryProviders(A.class)[0];
        IndexSearcher searcher = new IndexSearcher(provider.getDirectory(), true);
        TopDocs hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        searcher.close();
        sf = (MutableSearchFactory)builder.currentFactory((SearchFactoryIntegrator)sf).addClass(B.class).buildSearchFactory();
        tc = new ManualTransactionContext();
        MutableFactoryTest.doIndexWork(new B(1, "Noel"), 1, (SearchFactoryIntegrator)sf, tc);
        tc.end();
        luceneQuery = parser.parse("Noel");
        provider = sf.getDirectoryProviders(B.class)[0];
        searcher = new IndexSearcher(provider.getDirectory(), true);
        hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        searcher.close();
        sf.close();
    }

    @Test
    public void testAddingClassSimpleAPI() throws Exception {
        ManualConfiguration configuration = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram");
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        sf.addClasses(new Class[]{A.class});
        ManualTransactionContext tc = new ManualTransactionContext();
        MutableFactoryTest.doIndexWork(new A(1, "Emmanuel"), 1, (SearchFactoryIntegrator)sf, tc);
        tc.end();
        QueryParser parser = new QueryParser(SearchTestCase.getTargetLuceneVersion(), "name", SearchTestCase.standardAnalyzer);
        Query luceneQuery = parser.parse("Emmanuel");
        DirectoryProvider provider = sf.getDirectoryProviders(A.class)[0];
        IndexSearcher searcher = new IndexSearcher(provider.getDirectory(), true);
        TopDocs hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        searcher.close();
        sf.addClasses(new Class[]{B.class, C.class});
        tc = new ManualTransactionContext();
        MutableFactoryTest.doIndexWork(new B(1, "Noel"), 1, (SearchFactoryIntegrator)sf, tc);
        MutableFactoryTest.doIndexWork(new C(1, "Vincent"), 1, (SearchFactoryIntegrator)sf, tc);
        tc.end();
        luceneQuery = parser.parse("Noel");
        provider = sf.getDirectoryProviders(B.class)[0];
        searcher = new IndexSearcher(provider.getDirectory(), true);
        hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        luceneQuery = parser.parse("Vincent");
        provider = sf.getDirectoryProviders(C.class)[0];
        searcher = new IndexSearcher(provider.getDirectory(), true);
        hits = searcher.search(luceneQuery, 1000);
        Assert.assertEquals((long)1L, (long)hits.totalHits);
        searcher.close();
        sf.close();
    }

    private static void doIndexWork(Object entity, Integer id, SearchFactoryIntegrator sfi, ManualTransactionContext tc) {
        Work work = new Work(entity, (Serializable)id, WorkType.INDEX);
        sfi.getWorker().performWork(work, (TransactionContext)tc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiThreadedAddClasses() throws Exception {
        File indexDir = this.initIndexDirectory();
        try {
            this.doTestMultiThreadedClasses(indexDir);
        }
        finally {
            this.cleanIndexDir(indexDir);
        }
    }

    private void doTestMultiThreadedClasses(File indexDir) throws Exception {
        boolean inProgress;
        QueryParser parser = new QueryParser(SearchTestCase.getTargetLuceneVersion(), "name", SearchTestCase.standardAnalyzer);
        ManualConfiguration configuration = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "filesystem").addProperty("hibernate.search.default.indexBase", indexDir.getAbsolutePath());
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
        ArrayList<DoAddClasses> runnables = new ArrayList<DoAddClasses>(10);
        int nbrOfThread = 10;
        int nbrOfClassesPerThread = 10;
        for (int i = 0; i < 10; ++i) {
            runnables.add(new DoAddClasses((SearchFactoryIntegrator)sf, i, 10));
        }
        ThreadPoolExecutor poolExecutor = Executors.newFixedThreadPool((int)10, (String)"SFI classes addition");
        poolExecutor.prestartAllCoreThreads();
        for (DoAddClasses runnable : runnables) {
            poolExecutor.execute(runnable);
        }
        do {
            Thread.sleep(100L);
            inProgress = false;
            for (DoAddClasses runnable : runnables) {
                inProgress = inProgress || runnable.isFailure() == null;
            }
        } while (inProgress);
        for (DoAddClasses runnable : runnables) {
            Assert.assertNotNull((String)("Threads not run # " + runnable.getWorkNumber()), (Object)runnable.isFailure());
            Assert.assertFalse((String)("thread failed #" + runnable.getWorkNumber() + " Failure: " + runnable.getFailureInfo()), (boolean)runnable.isFailure());
        }
        poolExecutor.shutdown();
        for (int i = 0; i < 100; ++i) {
            Query luceneQuery = parser.parse("Emmanuel" + i);
            Class<?> classByNumber = MutableFactoryTest.getClassAByNumber(i);
            DirectoryProvider provider = sf.getDirectoryProviders(classByNumber)[0];
            IndexSearcher searcher = new IndexSearcher(provider.getDirectory(), true);
            TopDocs hits = searcher.search(luceneQuery, 1000);
            Assert.assertEquals((long)1L, (long)hits.totalHits);
        }
    }

    private void cleanIndexDir(File indexDir) {
        FileHelper.delete((File)indexDir);
    }

    private File initIndexDirectory() {
        File current;
        File indexDir;
        boolean created;
        String buildDir = System.getProperty("build.dir");
        if (buildDir == null) {
            buildDir = ".";
        }
        if (!(created = (indexDir = new File(current = new File(buildDir), "indextemp")).mkdir())) {
            FileHelper.delete((File)indexDir);
            indexDir.mkdir();
        }
        return indexDir;
    }

    private static Class<?> getClassAByNumber(int i) throws ClassNotFoundException {
        Class aClass = ReflectHelper.classForName((String)Generated.A0.class.getName().replace("A0", "A" + i));
        return aClass;
    }

    private static class DoAddClasses
    implements Runnable {
        private final SearchFactoryIntegrator factory;
        private final int factorOfClassesPerThread;
        private final QueryParser parser;
        private final int nbrOfClassesPerThread;
        private volatile Boolean failure;
        private volatile String failureInfo;

        public String getFailureInfo() {
            return this.failureInfo;
        }

        public Boolean isFailure() {
            return this.failure;
        }

        public int getWorkNumber() {
            return this.factorOfClassesPerThread;
        }

        public DoAddClasses(SearchFactoryIntegrator factory, int factorOfClassesPerThread, int nbrOfClassesPerThread) {
            this.factory = factory;
            this.factorOfClassesPerThread = factorOfClassesPerThread;
            this.parser = new QueryParser(SearchTestCase.getTargetLuceneVersion(), "name", SearchTestCase.standardAnalyzer);
            this.nbrOfClassesPerThread = nbrOfClassesPerThread;
        }

        public void run() {
            try {
                for (int index = 0; index < 10; ++index) {
                    int i = this.factorOfClassesPerThread * this.nbrOfClassesPerThread + index;
                    Class aClass = MutableFactoryTest.getClassAByNumber(i);
                    this.factory.addClasses(new Class[]{aClass});
                    Object entity = aClass.getConstructor(Integer.class, String.class).newInstance(i, "Emmanuel" + i);
                    ManualTransactionContext context = new ManualTransactionContext();
                    MutableFactoryTest.doIndexWork(entity, i, this.factory, context);
                    context.end();
                    Query luceneQuery = this.parser.parse("Emmanuel" + i);
                    DirectoryProvider provider = this.factory.getDirectoryProviders(aClass)[0];
                    IndexSearcher searcher = new IndexSearcher(provider.getDirectory(), true);
                    TopDocs hits = searcher.search(luceneQuery, 1000);
                    if (hits.totalHits == 1) continue;
                    this.failure = true;
                    this.failureInfo = "failure: Emmanuel" + i + " for " + aClass.getName();
                    return;
                }
                this.failure = false;
            }
            catch (Exception e) {
                this.failure = true;
                e.printStackTrace();
                this.failureInfo = "failure: Emmanuel" + this.factorOfClassesPerThread + " exception: " + e.toString();
            }
        }
    }
}

