/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.shards;

import java.io.Serializable;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IdHashShardingStrategy;
import org.hibernate.search.store.RAMDirectoryProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IdShardingStrategyTest {
    private IdHashShardingStrategy shardStrategy;

    @Before
    public void setUp() throws Exception {
        this.shardStrategy = new IdHashShardingStrategy();
        this.shardStrategy.initialize(null, new DirectoryProvider[]{new RAMDirectoryProvider(), new RAMDirectoryProvider()});
    }

    @Test
    public void testHashOverflow() {
        String key = String.valueOf(0x7FFFFFFE);
        Assert.assertTrue((key.hashCode() < 0 ? 1 : 0) != 0);
        this.assertAcceptableId(key);
    }

    private void assertAcceptableId(String id) {
        this.shardStrategy.getDirectoryProviderForAddition(null, (Serializable)((Object)id), id, null);
        this.shardStrategy.getDirectoryProvidersForDeletion(null, (Serializable)((Object)id), id);
    }
}

