/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.List;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.bridge.Department;
import org.hibernate.search.test.bridge.Departments;

public class ClassBridgeTest
extends SearchTestCase {
    public void testClassBridges() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)this.getDepts1());
        s.persist((Object)this.getDepts2());
        s.persist((Object)this.getDepts3());
        s.persist((Object)this.getDepts4());
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(ClassBridgeTest.getTargetLuceneVersion(), "equipment", SearchTestCase.simpleAnalyzer);
        Query query = parser.parse("equiptype:Cisco");
        FullTextQuery hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        List result = hibQuery.list();
        ClassBridgeTest.assertNotNull((Object)result);
        ClassBridgeTest.assertEquals((String)"incorrect number of results returned", (int)2, (int)result.size());
        for (Departments d : result) {
            ClassBridgeTest.assertEquals((String)"incorrect manufacturer", (String)"C", (String)d.getManufacturer());
        }
        query = parser.parse("branchnetwork:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        ClassBridgeTest.assertNotNull((Object)result);
        ClassBridgeTest.assertTrue((String)"problem with field cross-ups", (result.size() == 0 ? 1 : 0) != 0);
        parser = new QueryParser(ClassBridgeTest.getTargetLuceneVersion(), "branchHead", SearchTestCase.simpleAnalyzer);
        query = parser.parse("branchHead:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        ClassBridgeTest.assertNotNull((Object)result);
        ClassBridgeTest.assertTrue((String)"incorrect entity returned, wrong branch head", (result.size() == 1 ? 1 : 0) != 0);
        ClassBridgeTest.assertEquals((String)"incorrect entity returned", (String)"Kent Lewin", (String)((Departments)result.get(0)).getBranchHead());
        parser = new QueryParser(ClassBridgeTest.getTargetLuceneVersion(), "branchnetwork", SearchTestCase.simpleAnalyzer);
        query = parser.parse("branchnetwork:st. george 1D");
        hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        result = hibQuery.list();
        ClassBridgeTest.assertNotNull((Object)result);
        ClassBridgeTest.assertEquals((String)"incorrect entity returned, wrong network", (String)"1D", (String)((Departments)result.get(0)).getNetwork());
        ClassBridgeTest.assertEquals((String)"incorrect entity returned, wrong branch", (String)"St. George", (String)((Departments)result.get(0)).getBranch());
        ClassBridgeTest.assertEquals((String)"incorrect number of results returned", (int)1, (int)result.size());
        for (Object element : s.createQuery("from " + Departments.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testClassBridgesWithProjection() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)this.getDepts1());
        s.persist((Object)this.getDepts2());
        s.persist((Object)this.getDepts3());
        s.persist((Object)this.getDepts4());
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(ClassBridgeTest.getTargetLuceneVersion(), "equipment", SearchTestCase.simpleAnalyzer);
        Query query = parser.parse("equiptype:Cisco");
        FullTextQuery hibQuery = session.createFullTextQuery(query, new Class[]{Departments.class});
        hibQuery.setProjection(new String[]{"__HSearch_This", "__HSearch_Document"});
        ScrollableResults projections = hibQuery.scroll();
        ClassBridgeTest.assertNotNull((Object)projections);
        projections.beforeFirst();
        projections.next();
        Object[] projection = projections.get();
        ClassBridgeTest.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[0] instanceof Departments));
        ClassBridgeTest.assertEquals((String)"id incorrect", (int)1, (int)((Departments)projection[0]).getId());
        ClassBridgeTest.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[1] instanceof Document));
        ClassBridgeTest.assertEquals((String)"DOCUMENT size incorrect", (int)8, (int)((Document)projection[1]).getFields().size());
        ClassBridgeTest.assertNotNull((String)"equiptype is null", (Object)((Document)projection[1]).getField("equiptype"));
        ClassBridgeTest.assertEquals((String)"equiptype incorrect", (String)"Cisco", (String)((Document)projection[1]).getField("equiptype").stringValue());
        ClassBridgeTest.assertNotNull((String)"branchnetwork is null", (Object)((Document)projection[1]).getField("branchnetwork"));
        ClassBridgeTest.assertEquals((String)"branchnetwork incorrect", (String)"Salt Lake City 1A", (String)((Document)projection[1]).getField("branchnetwork").stringValue());
        projections.next();
        projection = projections.get();
        ClassBridgeTest.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[0] instanceof Departments));
        ClassBridgeTest.assertEquals((String)"id incorrect", (int)4, (int)((Departments)projection[0]).getId());
        ClassBridgeTest.assertTrue((String)"DOCUMENT incorrect", (boolean)(projection[1] instanceof Document));
        ClassBridgeTest.assertEquals((String)"DOCUMENT size incorrect", (int)8, (int)((Document)projection[1]).getFields().size());
        ClassBridgeTest.assertNotNull((String)"equiptype is null", (Object)((Document)projection[1]).getField("equiptype"));
        ClassBridgeTest.assertEquals((String)"equiptype incorrect", (String)"Cisco", (String)((Document)projection[1]).getField("equiptype").stringValue());
        ClassBridgeTest.assertNotNull((String)"branchnetwork is null", (Object)((Document)projection[1]).getField("branchnetwork"));
        ClassBridgeTest.assertEquals((String)"branchnetwork incorrect", (String)"St. George 1D", (String)((Document)projection[1]).getField("branchnetwork").stringValue());
        ClassBridgeTest.assertTrue((String)"incorrect result count returned", (boolean)projections.isLast());
        for (Object element : s.createQuery("from " + Departments.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    public void testClassBridge() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)this.getDept1());
        s.persist((Object)this.getDept2());
        s.persist((Object)this.getDept3());
        s.flush();
        tx.commit();
        tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser(ClassBridgeTest.getTargetLuceneVersion(), "branchnetwork", SearchTestCase.simpleAnalyzer);
        Query query = parser.parse("branchnetwork:layton 2B");
        FullTextQuery hibQuery = session.createFullTextQuery(query, new Class[]{Department.class});
        List result = hibQuery.list();
        ClassBridgeTest.assertNotNull((Object)result);
        ClassBridgeTest.assertEquals((String)"incorrect entity returned, wrong network", (String)"2B", (String)((Department)result.get(0)).getNetwork());
        ClassBridgeTest.assertEquals((String)"incorrect entity returned, wrong branch", (String)"Layton", (String)((Department)result.get(0)).getBranch());
        ClassBridgeTest.assertEquals((String)"incorrect number of results returned", (int)1, (int)result.size());
        query = parser.parse("branchnetwork:3c");
        hibQuery = session.createFullTextQuery(query, new Class[]{Department.class});
        result = hibQuery.list();
        ClassBridgeTest.assertNotNull((Object)result);
        ClassBridgeTest.assertEquals((String)"incorrect entity returned, wrong network", (String)"3C", (String)((Department)result.get(0)).getNetwork());
        ClassBridgeTest.assertEquals((String)"incorrect entity returned, wrong branch", (String)"West Valley", (String)((Department)result.get(0)).getBranch());
        ClassBridgeTest.assertEquals((String)"incorrect number of results returned", (int)1, (int)result.size());
        query = parser.parse("branchnetwork:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Department.class});
        result = hibQuery.list();
        ClassBridgeTest.assertNotNull((Object)result);
        ClassBridgeTest.assertTrue((String)"problem with field cross-ups", (result.size() == 0 ? 1 : 0) != 0);
        parser = new QueryParser(ClassBridgeTest.getTargetLuceneVersion(), "branchHead", SearchTestCase.simpleAnalyzer);
        query = parser.parse("branchHead:Kent Lewin");
        hibQuery = session.createFullTextQuery(query, new Class[]{Department.class});
        result = hibQuery.list();
        ClassBridgeTest.assertNotNull((Object)result);
        ClassBridgeTest.assertTrue((String)"incorrect entity returned, wrong branch head", (result.size() == 1 ? 1 : 0) != 0);
        ClassBridgeTest.assertEquals((String)"incorrect entity returned", (String)"Kent Lewin", (String)((Department)result.get(0)).getBranchHead());
        for (Object element : s.createQuery("from " + Department.class.getName()).list()) {
            s.delete(element);
        }
        tx.commit();
        s.close();
    }

    private Department getDept1() {
        Department dept = new Department();
        dept.setBranch("Salt Lake City");
        dept.setBranchHead("Kent Lewin");
        dept.setMaxEmployees(100);
        dept.setNetwork("1A");
        return dept;
    }

    private Department getDept2() {
        Department dept = new Department();
        dept.setBranch("Layton");
        dept.setBranchHead("Terry Poperszky");
        dept.setMaxEmployees(20);
        dept.setNetwork("2B");
        return dept;
    }

    private Department getDept3() {
        Department dept = new Department();
        dept.setBranch("West Valley");
        dept.setBranchHead("Pat Kelley");
        dept.setMaxEmployees(15);
        dept.setNetwork("3C");
        return dept;
    }

    private Departments getDepts1() {
        Departments depts = new Departments();
        depts.setBranch("Salt Lake City");
        depts.setBranchHead("Kent Lewin");
        depts.setMaxEmployees(100);
        depts.setNetwork("1A");
        depts.setManufacturer("C");
        return depts;
    }

    private Departments getDepts2() {
        Departments depts = new Departments();
        depts.setBranch("Layton");
        depts.setBranchHead("Terry Poperszky");
        depts.setMaxEmployees(20);
        depts.setNetwork("2B");
        depts.setManufacturer("3");
        return depts;
    }

    private Departments getDepts3() {
        Departments depts = new Departments();
        depts.setBranch("West Valley");
        depts.setBranchHead("Pat Kelley");
        depts.setMaxEmployees(15);
        depts.setNetwork("3C");
        depts.setManufacturer("D");
        return depts;
    }

    private Departments getDepts4() {
        Departments depts = new Departments();
        depts.setBranch("St. George");
        depts.setBranchHead("Spencer Stajskal");
        depts.setMaxEmployees(10);
        depts.setNetwork("1D");
        depts.setManufacturer("C");
        return depts;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Department.class, Departments.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
    }
}

