/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge;

import java.util.Date;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.bridge.IterableBridgeTestEntity;

public class IterableBridgeTest
extends SearchTestCase {
    private FullTextSession fullTextSession;
    private IterableBridgeTestEntity withoutNull;
    private IterableBridgeTestEntity withNullEntry;
    private IterableBridgeTestEntity withNullEmbedded;
    private Date indexedDate;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.prepareData();
    }

    @Override
    protected void tearDown() throws Exception {
        this.cleanData();
        IterableBridgeTest.assertTrue((boolean)this.indexIsEmpty());
        super.tearDown();
    }

    private void prepareData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        this.withoutNull = this.persistEntity((Session)this.fullTextSession, "Davide D'Alto");
        this.withoutNull.addNullIndexed(IterableBridgeTestEntity.Language.ITALIAN);
        this.withoutNull.addNullIndexed(IterableBridgeTestEntity.Language.ENGLISH);
        this.withoutNull.addNumericNullIndexed(1);
        this.withoutNull.addNumericNullIndexed(2);
        this.withoutNull.addNullNotIndexed("DaltoValue");
        this.withoutNull.addNullNotIndexed("DavideValue");
        this.withoutNull.addNumericNullNotIndexed(3L);
        this.withoutNull.addNumericNullNotIndexed(4L);
        this.indexedDate = new Date();
        this.withoutNull.addDate(this.indexedDate);
        this.withNullEntry = this.persistEntity((Session)this.fullTextSession, "Worf");
        this.withNullEntry.addNullIndexed(IterableBridgeTestEntity.Language.KLINGON);
        this.withNullEntry.addNullIndexed(IterableBridgeTestEntity.Language.ENGLISH);
        this.withNullEntry.addNullIndexed(null);
        this.withNullEntry.addNumericNullIndexed(11);
        this.withNullEntry.addNumericNullIndexed(null);
        this.withNullEntry.addNullNotIndexed("WorfValue");
        this.withNullEntry.addNullNotIndexed(null);
        this.withNullEntry.addNumericNullNotIndexed(33L);
        this.withNullEntry.addNumericNullNotIndexed(null);
        this.withNullEntry.addDate(null);
        this.withNullEmbedded = this.persistEntity((Session)this.fullTextSession, "Mime");
        this.withNullEmbedded.setDates(null);
        this.withNullEmbedded.setNumericNullIndexed(null);
        this.withNullEmbedded.setNumericNullNotIndexed(null);
        this.withNullEmbedded.setNullIndexed(null);
        this.withNullEmbedded.setNullNotIndexed(null);
        this.withNullEmbedded.setDates(null);
        tx.commit();
    }

    public void testSearchNullEntry() throws Exception {
        List<IterableBridgeTestEntity> results = this.findResults("nullIndexed", "NULL_MARKER");
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        IterableBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNullEmbedded() throws Exception {
        List<IterableBridgeTestEntity> results = this.findEmbeddedNullResults("nullIndexed", "EMBEDDED_NULL");
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        IterableBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection", (String)this.withNullEmbedded.getName(), (String)results.get(0).getName());
    }

    public void testSearchNullNumericEmbedded() throws Exception {
        List<IterableBridgeTestEntity> results = this.findEmbeddedNullResults("embeddedNum", "EMBEDDED_NUMERIC_NULL");
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        IterableBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (String)this.withNullEmbedded.getName(), (String)results.get(0).getName());
    }

    public void testSearchNullNumericEntry() throws Exception {
        List<IterableBridgeTestEntity> results = this.findResults("numericNullIndexed", "NULL_NUMERIC_MARKER");
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        IterableBridgeTest.assertEquals((String)"Unexpected number of results in a collection", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned looking for a null in a collection of numeric", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNotNullEntry() throws Exception {
        List<IterableBridgeTestEntity> results = this.findResults("nullIndexed", (Object)IterableBridgeTestEntity.Language.KLINGON);
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        IterableBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)IterableBridgeTestEntity.Language.ITALIAN);
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        IterableBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findResults("nullIndexed", (Object)IterableBridgeTestEntity.Language.ENGLISH);
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        IterableBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)2, (int)results.size());
    }

    public void testSearchEntryWhenNullEntryNotIndexed() throws Exception {
        List<IterableBridgeTestEntity> results = this.findResults("nullNotIndexed", "DaltoValue");
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        IterableBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findResults("nullNotIndexed", "WorfValue");
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        IterableBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNotNullNumeric() throws Exception {
        List<IterableBridgeTestEntity> results = this.findNumericResults("numericNullIndexed", 1);
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        IterableBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findNumericResults("numericNullIndexed", 11);
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        IterableBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned from an indexed collection", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testSearchNotNullNumericEntryWhenNullEntryNotIndexed() throws Exception {
        List<IterableBridgeTestEntity> results = this.findNumericResults("numericNullNotIndexed", 3L);
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        IterableBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withoutNull.getName(), (String)results.get(0).getName());
        results = this.findNumericResults("numericNullNotIndexed", 33L);
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed array", results);
        IterableBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed array", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned from an indexed array", (String)this.withNullEntry.getName(), (String)results.get(0).getName());
    }

    public void testDateIndexing() throws Exception {
        List<IterableBridgeTestEntity> results = this.findResults("dates", this.indexedDate);
        IterableBridgeTest.assertNotNull((String)"No result found for an indexed collection", results);
        IterableBridgeTest.assertEquals((String)"Wrong number of results returned for an indexed collection", (int)1, (int)results.size());
        IterableBridgeTest.assertEquals((String)"Wrong result returned from a collection of Date", (String)this.withoutNull.getName(), (String)results.get(0).getName());
    }

    private List<IterableBridgeTestEntity> findEmbeddedNullResults(String fieldName, Object value) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(IterableBridgeTestEntity.class).get();
        Query query = ((TermMatchingContext)queryBuilder.keyword().onField(fieldName).ignoreAnalyzer()).matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{IterableBridgeTestEntity.class}).list();
    }

    private List<IterableBridgeTestEntity> findResults(String fieldName, Object value) {
        QueryBuilder queryBuilder = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(IterableBridgeTestEntity.class).get();
        Query query = queryBuilder.keyword().onField(fieldName).matching(value).createQuery();
        return this.fullTextSession.createFullTextQuery(query, new Class[]{IterableBridgeTestEntity.class}).list();
    }

    private List<IterableBridgeTestEntity> findNumericResults(String fieldName, Object number) {
        Query query = NumericFieldUtils.createNumericRangeQuery((String)fieldName, (Object)number, (Object)number, (boolean)true, (boolean)true);
        return this.fullTextSession.createFullTextQuery(query, new Class[]{IterableBridgeTestEntity.class}).list();
    }

    private IterableBridgeTestEntity persistEntity(Session s, String name) {
        IterableBridgeTestEntity boy = new IterableBridgeTestEntity();
        boy.setName(name);
        s.persist((Object)boy);
        return boy;
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{IterableBridgeTestEntity.class};
    }

    private void cleanData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        List locations = this.fullTextSession.createCriteria(IterableBridgeTestEntity.class).list();
        for (IterableBridgeTestEntity location : locations) {
            this.fullTextSession.delete((Object)location);
        }
        tx.commit();
        this.fullTextSession.close();
    }

    private boolean indexIsEmpty() {
        int numDocsForeigner = this.countSizeForType(IterableBridgeTestEntity.class);
        return numDocsForeigner == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countSizeForType(Class<?> type) {
        SearchFactory searchFactory = this.fullTextSession.getSearchFactory();
        int numDocs = -1;
        IndexReader locationIndexReader = searchFactory.openIndexReader(new Class[]{type});
        try {
            numDocs = locationIndexReader.numDocs();
        }
        finally {
            searchFactory.closeIndexReader(locationIndexReader);
        }
        return numDocs;
    }
}

