/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.configuration.impl.IndexWriterSetting;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.test.SearchTestCase;

public abstract class ConfigurationReadTestCase
extends SearchTestCase {
    private SearchFactoryImplementor searchFactory;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        this.searchFactory = (SearchFactoryImplementor)fullTextSession.getSearchFactory();
        fullTextSession.close();
    }

    protected final void assertValueIsDefault(Class testEntity, IndexWriterSetting setting) {
        this.assertValueIsDefault(testEntity, 0, setting);
    }

    protected final void assertValueIsDefault(Class testEntity, int shard, IndexWriterSetting setting) {
        ConfigurationReadTestCase.assertNull((String)("shard:" + shard + " setting:" + setting.getKey() + " : value was expected unset!"), (Object)this.getParameter(shard, setting, testEntity));
    }

    protected final void assertValueIsSet(Class testEntity, IndexWriterSetting setting, int expectedValue) {
        this.assertValueIsSet(testEntity, 0, setting, expectedValue);
    }

    protected final void assertValueIsSet(Class testEntity, int shard, IndexWriterSetting setting, int expectedValue) {
        ConfigurationReadTestCase.assertNotNull((String)("shard:" + shard + " setting:" + setting.getKey()), (Object)this.getParameter(shard, setting, testEntity));
        ConfigurationReadTestCase.assertEquals((String)("shard:" + shard + " setting:" + setting.getKey()), (int)expectedValue, (int)this.getParameter(shard, setting, testEntity));
    }

    protected final SearchFactoryImplementor getSearchFactory() {
        return this.searchFactory;
    }

    private Integer getParameter(int shard, IndexWriterSetting setting, Class testEntity) {
        EntityIndexBinder mappingForEntity = this.searchFactory.getIndexBindingForEntity(testEntity);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)mappingForEntity.getIndexManagers()[shard];
        LuceneIndexingParameters luceneIndexingParameters = indexManager.getIndexingParameters();
        return luceneIndexingParameters.getIndexParameters().getCurrentValueFor(setting);
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.indexBase", this.getBaseIndexDir().getAbsolutePath());
    }

    public static void assertCfgIsInvalid(Configuration configuration, Class[] mapping) {
        try {
            for (Class annotated : mapping) {
                configuration.addAnnotatedClass(annotated);
            }
            configuration.setProperty("hibernate.search.default.directory_provider", "ram");
            configuration.buildSessionFactory();
            ConfigurationReadTestCase.fail();
        }
        catch (HibernateException e) {
            Throwable cause = e.getCause();
            ConfigurationReadTestCase.assertTrue((boolean)(cause instanceof SearchException));
        }
    }
}

