/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import org.hibernate.search.SearchException;
import org.hibernate.search.test.directoryProvider.CustomLockFactoryProvider;
import org.hibernate.search.test.directoryProvider.SnowStorm;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.junit.Assert;
import org.junit.Test;

public class CustomLockProviderTest {
    @Test
    public void testUseOfCustomLockingFactory() {
        Assert.assertNull((Object)CustomLockFactoryProvider.optionValue);
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        builder.addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.locking_option", "somethingHere").setProperty("hibernate.search.default.locking_strategy", "org.hibernate.search.test.directoryProvider.CustomLockFactoryProvider").build();
        builder.close();
        Assert.assertEquals((Object)"somethingHere", (Object)CustomLockFactoryProvider.optionValue);
    }

    @Test
    public void testFailOnInexistentLockingFactory() {
        FullTextSessionBuilder builder = new FullTextSessionBuilder();
        try {
            builder.addAnnotatedClass(SnowStorm.class).setProperty("hibernate.search.default.locking_option", "somethingHere").setProperty("hibernate.search.default.locking_strategy", "org.hibernate.NotExistingFactory").build();
            builder.close();
            Assert.fail();
        }
        catch (SearchException e) {
            Assert.assertEquals((Object)"Unable to find locking_strategy implementation class: org.hibernate.NotExistingFactory", (Object)e.getCause().getMessage());
        }
    }
}

