/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.directoryProvider;

import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.lucene.util.Version;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.search.test.SearchTestCase;

public abstract class MultipleSFTestCase
extends TestCase {
    private static SessionFactory[] sessionFactories;
    private static Configuration[] cfgs;
    private static Dialect dialect;
    private static Class lastTestClass;

    protected abstract int getSFNbrs();

    protected void buildSessionFactories(Class[] classes, String[] packages, String[] xmlFiles) throws Exception {
        int sfIndex;
        if (sessionFactories == null) {
            sessionFactories = new SessionFactory[this.getSFNbrs()];
        }
        if (cfgs == null) {
            cfgs = new Configuration[this.getSFNbrs()];
        }
        for (SessionFactory sf : sessionFactories) {
            if (sf == null) continue;
            sf.close();
        }
        for (sfIndex = 0; sfIndex < this.getSFNbrs(); ++sfIndex) {
            MultipleSFTestCase.cfgs[sfIndex] = new Configuration();
        }
        this.configure(cfgs);
        for (sfIndex = 0; sfIndex < this.getSFNbrs(); ++sfIndex) {
            try {
                if (this.recreateSchema()) {
                    cfgs[sfIndex].setProperty("hibernate.hbm2ddl.auto", "create-drop");
                }
                for (String aPackage : packages) {
                    cfgs[sfIndex].addPackage(aPackage);
                }
                for (Class aClass : classes) {
                    cfgs[sfIndex].addAnnotatedClass(aClass);
                }
                for (String xmlFile : xmlFiles) {
                    InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);
                    cfgs[sfIndex].addInputStream(is);
                }
                this.setDialect(Dialect.getDialect());
                MultipleSFTestCase.sessionFactories[sfIndex] = cfgs[sfIndex].buildSessionFactory();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    protected void setUp() throws Exception {
        if (sessionFactories == null || sessionFactories[0] == null || lastTestClass != ((Object)((Object)this)).getClass()) {
            this.buildSessionFactories(this.getAnnotatedClasses(), this.getAnnotatedPackages(), this.getXmlFiles());
            lastTestClass = ((Object)((Object)this)).getClass();
        }
    }

    protected void tearDown() throws Exception {
        for (SessionFactory sf : MultipleSFTestCase.getSessionFactories()) {
            sf.close();
        }
    }

    protected abstract Class[] getAnnotatedClasses();

    protected String[] getAnnotatedPackages() {
        return new String[0];
    }

    protected String[] getXmlFiles() {
        return new String[0];
    }

    private void setDialect(Dialect dialect) {
        MultipleSFTestCase.dialect = dialect;
    }

    protected Dialect getDialect() {
        return dialect;
    }

    protected abstract void configure(Configuration[] var1);

    protected boolean recreateSchema() {
        return true;
    }

    public static SessionFactory[] getSessionFactories() {
        return sessionFactories;
    }

    public static Version getTargetLuceneVersion() {
        return SearchTestCase.getTargetLuceneVersion();
    }
}

