/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.util.List;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.engine.BusLine;
import org.hibernate.search.test.engine.BusStop;
import org.hibernate.search.test.util.FieldSelectorLeakingReaderProvider;

public class LazyCollectionsUpdatingTest
extends SearchTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdatingInTransaction() {
        this.assertFindsByRoadName("buonarroti");
        FullTextSession fullTextSession = Search.getFullTextSession((Session)sessions.openSession());
        try {
            Transaction tx = fullTextSession.beginTransaction();
            FieldSelectorLeakingReaderProvider.resetFieldSelector();
            List list = fullTextSession.createCriteria(BusStop.class).list();
            FieldSelectorLeakingReaderProvider.assertFieldSelectorDisabled();
            LazyCollectionsUpdatingTest.assertNotNull((Object)list);
            LazyCollectionsUpdatingTest.assertEquals((int)4, (int)list.size());
            BusStop busStop = (BusStop)list.get(1);
            busStop.setRoadName("new road");
            tx.commit();
        }
        catch (AssertionFailure ass) {
            LazyCollectionsUpdatingTest.fail((String)ass.getMessage());
        }
        finally {
            fullTextSession.close();
        }
        this.assertFindsByRoadName("new");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdatingOutOfTransaction() {
        this.assertFindsByRoadName("buonarroti");
        FullTextSession fullTextSession = Search.getFullTextSession((Session)sessions.openSession());
        try {
            List list = fullTextSession.createCriteria(BusStop.class).list();
            LazyCollectionsUpdatingTest.assertNotNull((Object)list);
            LazyCollectionsUpdatingTest.assertEquals((int)4, (int)list.size());
            BusStop busStop = (BusStop)list.get(1);
            busStop.setRoadName("new road");
            fullTextSession.flush();
        }
        catch (AssertionFailure ass) {
            LazyCollectionsUpdatingTest.fail((String)ass.getMessage());
        }
        finally {
            fullTextSession.close();
        }
        this.assertFindsByRoadName("new");
    }

    public void assertFindsByRoadName(String analyzedRoadname) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)sessions.openSession());
        FieldSelectorLeakingReaderProvider.resetFieldSelector();
        Transaction tx = fullTextSession.beginTransaction();
        TermQuery ftQuery = new TermQuery(new Term("stops.roadName", analyzedRoadname));
        FullTextQuery query = fullTextSession.createFullTextQuery((Query)ftQuery, new Class[]{BusLine.class});
        query.setProjection(new String[]{"busLineName"});
        LazyCollectionsUpdatingTest.assertEquals((int)1, (int)query.list().size());
        List results = query.list();
        FieldSelectorLeakingReaderProvider.assertFieldSelectorEnabled("busLineName");
        String resultName = (String)((Object[])results.get(0))[0];
        LazyCollectionsUpdatingTest.assertEquals((String)"Linea 64", (String)resultName);
        tx.commit();
        fullTextSession.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.openSession();
        Transaction tx = null;
        try {
            tx = this.session.beginTransaction();
            BusLine bus = new BusLine();
            bus.setBusLineName("Linea 64");
            LazyCollectionsUpdatingTest.addBusStop(bus, "Stazione Termini");
            LazyCollectionsUpdatingTest.addBusStop(bus, "via Gregorio VII");
            LazyCollectionsUpdatingTest.addBusStop(bus, "via Alessandro III");
            LazyCollectionsUpdatingTest.addBusStop(bus, "via M.Buonarroti");
            this.session.persist((Object)bus);
            tx.commit();
        }
        catch (Throwable t) {
            if (tx != null) {
                tx.rollback();
            }
        }
        finally {
            this.session.close();
        }
    }

    static void addBusStop(BusLine bus, String roadName) {
        BusStop stop = new BusStop();
        stop.setRoadName(roadName);
        bus.getStops().add(stop);
        stop.getBusses().add(bus);
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{BusLine.class, BusStop.class};
    }

    @Override
    protected void configure(Configuration configuration) {
        super.configure(configuration);
        cfg.setProperty("hibernate.search.default.directory_provider", "ram");
        cfg.setProperty("hibernate.search.default.reader.strategy", FieldSelectorLeakingReaderProvider.class.getName());
        cfg.setProperty("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
    }
}

