/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.io.Serializable;
import junit.framework.Assert;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.depth.LeakingLuceneBackend;
import org.hibernate.search.test.engine.BusLine;
import org.hibernate.search.test.engine.BusStop;
import org.hibernate.search.test.engine.LazyCollectionsUpdatingTest;

public class SkipIndexingWorkForUnaffectingChangesTest
extends SearchTestCase {
    public void testUnindexedFieldsDontTriggerEngine() {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        BusLine line1 = new BusLine();
        line1.setBusLineCode(1);
        line1.setBusLineName("Line Uno");
        LazyCollectionsUpdatingTest.addBusStop(line1, "Gateshead");
        LazyCollectionsUpdatingTest.addBusStop(line1, "The Sage");
        this.session.persist((Object)line1);
        tx.commit();
        Assert.assertEquals((int)1, (int)LeakingLuceneBackend.getLastProcessedQueue().size());
        LeakingLuceneBackend.reset();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        line1 = (BusLine)fullTextSession.load(BusLine.class, (Serializable)line1.getId());
        line1.setBusLineCode(2);
        line1.setOperating(true);
        BusStop busStop = line1.getStops().iterator().next();
        busStop.setServiceComments("please clean the garbage after the football match");
        tx.commit();
        if (this.isDirtyCheckEnabled()) {
            Assert.assertEquals((int)0, (int)LeakingLuceneBackend.getLastProcessedQueue().size());
        } else {
            Assert.assertEquals((int)1, (int)LeakingLuceneBackend.getLastProcessedQueue().size());
        }
        LeakingLuceneBackend.reset();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        busStop = (BusStop)fullTextSession.load(BusStop.class, (Serializable)busStop.getId());
        busStop.setRoadName("Mill Road");
        tx.commit();
        Assert.assertEquals((int)1, (int)LeakingLuceneBackend.getLastProcessedQueue().size());
        LeakingLuceneBackend.reset();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        busStop = (BusStop)fullTextSession.load(BusStop.class, (Serializable)busStop.getId());
        busStop.getStartingDate().setTime(0L);
        tx.commit();
        Assert.assertEquals((int)1, (int)LeakingLuceneBackend.getLastProcessedQueue().size());
        LeakingLuceneBackend.reset();
        fullTextSession.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{BusLine.class, BusStop.class};
    }

    @Override
    protected void configure(Configuration configuration) {
        super.configure(configuration);
        cfg.setProperty("hibernate.search.analyzer", SimpleAnalyzer.class.getName());
        cfg.setProperty("hibernate.search.default.worker.backend", LeakingLuceneBackend.class.getName());
    }

    protected boolean isDirtyCheckEnabled() {
        return true;
    }
}

