/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.engine;

import java.io.Serializable;
import java.util.List;
import junit.framework.Assert;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.test.Document;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.embedded.depth.LeakingLuceneBackend;
import org.hibernate.search.test.embedded.depth.PersonWithBrokenSocialSecurityNumber;
import org.hibernate.search.test.errorhandling.MockErrorHandler;

public class UsingIdentifierRollbackTest
extends SearchTestCase {
    public void testEntityDeletionWithoutIdentifier() {
        SearchFactoryImplementor searchFactoryImpl = this.getSearchFactoryImpl();
        MockErrorHandler errorHandler = (MockErrorHandler)searchFactoryImpl.getErrorHandler();
        Session s = this.getSessions().openSession();
        s.getTransaction().begin();
        s.persist((Object)new Document("Hibernate in Action", "Object/relational mapping with Hibernate", "blah blah blah"));
        s.getTransaction().commit();
        s.close();
        s = this.getSessions().openSession();
        s.getTransaction().begin();
        Document entity = (Document)s.get(Document.class, (Serializable)Long.valueOf(1L));
        Assert.assertNotNull((Object)entity);
        s.delete((Object)entity);
        s.getTransaction().commit();
        s.close();
        Assert.assertNull((String)"unexpected exception detected", (Object)errorHandler.getLastException());
    }

    public void testRolledBackIdentifiersOnUnusualDocumentId() {
        SearchFactoryImplementor searchFactoryImpl = this.getSearchFactoryImpl();
        MockErrorHandler errorHandler = (MockErrorHandler)searchFactoryImpl.getErrorHandler();
        Session s = this.getSessions().openSession();
        s.getTransaction().begin();
        s.persist((Object)new PersonWithBrokenSocialSecurityNumber(2L, "This guy is unaffected by identifier rollback"));
        s.getTransaction().commit();
        s.close();
        s = this.getSessions().openSession();
        s.getTransaction().begin();
        PersonWithBrokenSocialSecurityNumber entity = (PersonWithBrokenSocialSecurityNumber)s.get(PersonWithBrokenSocialSecurityNumber.class, (Serializable)Long.valueOf(2L));
        Assert.assertNotNull((Object)entity);
        s.delete((Object)entity);
        s.getTransaction().commit();
        s.close();
        Assert.assertNull((String)"unexpected exception detected", (Object)errorHandler.getLastException());
        List<LuceneWork> processedQueue = LeakingLuceneBackend.getLastProcessedQueue();
        Assert.assertEquals((int)1, (int)processedQueue.size());
        LuceneWork luceneWork = processedQueue.get(0);
        Assert.assertEquals((String)"100", (String)luceneWork.getIdInString());
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Document.class, PersonWithBrokenSocialSecurityNumber.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.use_identifier_rollback", "true");
        cfg.setProperty("hibernate.search.error_handler", MockErrorHandler.class.getName());
        cfg.setProperty("hibernate.search.default.worker.backend", LeakingLuceneBackend.class.getName());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        LeakingLuceneBackend.reset();
    }
}

