/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.filter;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FilterCacheModeType;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.test.filter.BestDriversFilter;
import org.hibernate.search.test.filter.ExcludeAllFilterFactory;
import org.hibernate.search.test.filter.InstanceBasedExcludeAllFilter;
import org.hibernate.search.test.filter.NullReturningEmptyFilter;
import org.hibernate.search.test.filter.SecurityFilterFactory;

@Entity
@Indexed
@FullTextFilterDefs(value={@FullTextFilterDef(name="bestDriver", impl=BestDriversFilter.class, cache=FilterCacheModeType.NONE), @FullTextFilterDef(name="security", impl=SecurityFilterFactory.class, cache=FilterCacheModeType.INSTANCE_AND_DOCIDSETRESULTS), @FullTextFilterDef(name="cacheresultstest", impl=ExcludeAllFilterFactory.class, cache=FilterCacheModeType.INSTANCE_AND_DOCIDSETRESULTS), @FullTextFilterDef(name="cacheinstancetest", impl=InstanceBasedExcludeAllFilter.class, cache=FilterCacheModeType.INSTANCE_ONLY), @FullTextFilterDef(name="empty", impl=NullReturningEmptyFilter.class, cache=FilterCacheModeType.INSTANCE_ONLY)})
public class Driver {
    @Id
    @DocumentId
    private int id;
    @Field(index=Index.TOKENIZED)
    private String name;
    @Field(index=Index.UN_TOKENIZED)
    private String teacher;
    @Field(index=Index.UN_TOKENIZED)
    private int score;
    @Field(index=Index.UN_TOKENIZED)
    @DateBridge(resolution=Resolution.YEAR)
    private Date delivery;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTeacher() {
        return this.teacher;
    }

    public void setTeacher(String teacher) {
        this.teacher = teacher;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public Date getDelivery() {
        return this.delivery;
    }

    public void setDelivery(Date delivery) {
        this.delivery = delivery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Driver driver = (Driver)o;
        if (this.id != driver.id) {
            return false;
        }
        if (this.score != driver.score) {
            return false;
        }
        if (this.delivery != null ? !this.delivery.equals(driver.delivery) : driver.delivery != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(driver.name) : driver.name != null) {
            return false;
        }
        return !(this.teacher == null ? driver.teacher != null : !this.teacher.equals(driver.teacher));
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.teacher != null ? this.teacher.hashCode() : 0);
        result = 31 * result + this.score;
        result = 31 * result + (this.delivery != null ? this.delivery.hashCode() : 0);
        return result;
    }
}

