/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jgroups.slave;

import java.io.Serializable;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.jgroups.slave.JGroupsReceiver;
import org.hibernate.search.test.jgroups.slave.TShirt;
import org.hibernate.search.util.impl.XMLHelper;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.Receiver;

public class JGroupsSlaveTest
extends SearchTestCase {
    private Channel channel;
    private final String CHANNEL_NAME = UUID.randomUUID().toString();

    public void testMessageSend() throws Exception {
        JGroupsReceiver.reset();
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        TShirt ts = new TShirt();
        ts.setLogo("Boston");
        ts.setSize("XXL");
        ts.setLength(23.3);
        TShirt ts2 = new TShirt();
        ts2.setLogo("Mapple leaves");
        ts2.setSize("L");
        ts2.setLength(23.32);
        s.persist((Object)ts);
        s.persist((Object)ts2);
        tx.commit();
        Thread.sleep(100L);
        JGroupsSlaveTest.assertEquals((int)1, (int)JGroupsReceiver.queues);
        JGroupsSlaveTest.assertEquals((int)2, (int)JGroupsReceiver.works);
        JGroupsReceiver.reset();
        s = this.openSession();
        tx = s.beginTransaction();
        ts = (TShirt)s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId()));
        ts.setLogo("Peter pan");
        tx.commit();
        Thread.sleep(100L);
        JGroupsSlaveTest.assertEquals((int)1, (int)JGroupsReceiver.queues);
        JGroupsSlaveTest.assertEquals((int)1, (int)JGroupsReceiver.works);
        JGroupsReceiver.reset();
        s = this.openSession();
        tx = s.beginTransaction();
        s.delete(s.get(TShirt.class, (Serializable)Integer.valueOf(ts.getId())));
        tx.commit();
        Thread.sleep(100L);
        JGroupsSlaveTest.assertEquals((int)1, (int)JGroupsReceiver.queues);
        JGroupsSlaveTest.assertEquals((int)1, (int)JGroupsReceiver.works);
        s.close();
    }

    private void prepareJGroupsChannel() throws Exception {
        this.channel = new JChannel(XMLHelper.elementFromString((String)this.prepareXmlJGroupsConfiguration()));
        this.channel.connect(this.CHANNEL_NAME);
        this.channel.setReceiver((Receiver)new JGroupsReceiver(this.getSearchFactoryImpl()));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.prepareJGroupsChannel();
    }

    @Override
    protected void tearDown() throws Exception {
        this.channel.close();
        super.tearDown();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{TShirt.class};
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default.worker.backend", "jgroupsSlave");
        cfg.setProperty("hibernate.search.default.worker.backend.jgroups.clusterName", this.CHANNEL_NAME);
        cfg.setProperty("hibernate.search.default.worker.backend.jgroups.configurationXml", this.prepareXmlJGroupsConfiguration());
    }

    private String prepareXmlJGroupsConfiguration() {
        return "<config><UDP     mcast_addr=\"228.10.10.10\"     mcast_port=\"45588\"     tos=\"8\"     ucast_recv_buf_size=\"20000000\"     ucast_send_buf_size=\"640000\"     mcast_recv_buf_size=\"25000000\"     mcast_send_buf_size=\"640000\"     loopback=\"false\"\n     discard_incompatible_packets=\"true\"     max_bundle_size=\"64000\"     max_bundle_timeout=\"30\"     use_incoming_packet_handler=\"true\"     ip_ttl=\"2\"     enable_bundling=\"true\"     enable_diagnostics=\"true\"     use_concurrent_stack=\"true\"     thread_naming_pattern=\"pl\"     thread_pool.enabled=\"true\"     thread_pool.min_threads=\"1\"     thread_pool.max_threads=\"5\"     thread_pool.keep_alive_time=\"500\"     thread_pool.queue_enabled=\"false\"     thread_pool.queue_max_size=\"100\"     thread_pool.rejection_policy=\"Run\"     oob_thread_pool.enabled=\"true\"     oob_thread_pool.min_threads=\"1\"     oob_thread_pool.max_threads=\"8\"     oob_thread_pool.keep_alive_time=\"500\"     oob_thread_pool.queue_enabled=\"false\"     oob_thread_pool.queue_max_size=\"100\"     oob_thread_pool.rejection_policy=\"Run\"/><PING timeout=\"100\" num_initial_members=\"2\"/><MERGE2 max_interval=\"30000\" min_interval=\"10000\"/><FD_SOCK/><FD timeout=\"10000\" max_tries=\"5\" shun=\"true\"/><VERIFY_SUSPECT timeout=\"1500\"/><pbcast.NAKACK             use_mcast_xmit=\"false\" gc_lag=\"0\"            retransmit_timeout=\"30,60,120,240,480\"            discard_delivered_msgs=\"false\"/><UNICAST timeout=\"30,60,120,240,360\"/><pbcast.STABLE stability_delay=\"1000\" desired_avg_gossip=\"50000\"            max_bytes=\"400000\"/>   <pbcast.GMS print_local_addr=\"true\" join_timeout=\"200\"            shun=\"false\"            view_bundling=\"true\"/><FC max_credits=\"20000000\" min_threshold=\"0.10\"/><FRAG2 frag_size=\"60000\"/><pbcast.STREAMING_STATE_TRANSFER /><pbcast.FLUSH timeout=\"0\"/></config>";
    }
}

