/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jpa;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.persistence.EntityManager;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.jpa.Bretzel;
import org.hibernate.search.test.jpa.JPATestCase;

public class EntityManagerSerializationTest
extends JPATestCase {
    public void testSerialization() throws Exception {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        this.indexSearchAssert(em);
        File tmpFile = File.createTempFile("entityManager", "ser", null);
        this.serializeEM(em, tmpFile);
        em = this.deserializeEM(tmpFile);
        this.indexSearchAssert(em);
        em.close();
        tmpFile.delete();
    }

    private FullTextEntityManager deserializeEM(File tmpFile) throws ClassNotFoundException {
        FullTextEntityManager em = null;
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(tmpFile);
            in = new ObjectInputStream(fis);
            em = (FullTextEntityManager)in.readObject();
            in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            EntityManagerSerializationTest.fail();
        }
        return em;
    }

    private void serializeEM(FullTextEntityManager em, File tmpFile) {
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(tmpFile);
            out = new ObjectOutputStream(fos);
            out.writeObject(em);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            EntityManagerSerializationTest.fail();
        }
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{Bretzel.class};
    }

    private void indexSearchAssert(FullTextEntityManager em) throws Exception {
        em.getTransaction().begin();
        Bretzel bretzel = new Bretzel(23.0f, 34.0f);
        em.persist((Object)bretzel);
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        QueryParser parser = new QueryParser(SearchTestCase.getTargetLuceneVersion(), "title", SearchTestCase.stopAnalyzer);
        Query query = parser.parse("saltQty:noword");
        EntityManagerSerializationTest.assertEquals((int)0, (int)em.createFullTextQuery(query, new Class[0]).getResultList().size());
        query = new TermQuery(new Term("saltQty", "23.0"));
        EntityManagerSerializationTest.assertEquals((String)"getResultList", (int)1, (int)em.createFullTextQuery(query, new Class[0]).getResultList().size());
        EntityManagerSerializationTest.assertEquals((String)"getSingleResult and object retrieval", (Object)Float.valueOf(23.0f), (Object)Float.valueOf(((Bretzel)em.createFullTextQuery(query, new Class[0]).getSingleResult()).getSaltQty()));
        EntityManagerSerializationTest.assertEquals((int)1, (int)em.createFullTextQuery(query, new Class[0]).getResultSize());
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        em.remove(em.find(Bretzel.class, (Object)bretzel.getId()));
        em.getTransaction().commit();
    }
}

