/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.proxy;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.proxy.Author;
import org.hibernate.search.test.proxy.IAuthor;
import org.hibernate.search.test.proxy.IBook;

@Entity
@Indexed(index="Book")
@Proxy(proxyClass=IBook.class)
public class Book
implements IBook {
    private Integer id;
    private String body;
    private String summary;
    private Set<IAuthor> authors = new HashSet<IAuthor>();

    public Book() {
    }

    public Book(Integer id, String summary, String body) {
        this.id = id;
        this.summary = summary;
        this.body = body;
    }

    @Id
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @OneToMany(targetEntity=Author.class, mappedBy="book", cascade={CascadeType.ALL})
    @IndexedEmbedded(targetElement=Author.class)
    public Set<IAuthor> getAuthors() {
        return this.authors;
    }

    public void setAuthors(Set<IAuthor> authors) {
        this.authors = authors;
    }

    @Field(index=Index.TOKENIZED, store=Store.NO)
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    @Fields(value={@Field(index=Index.TOKENIZED, store=Store.YES), @Field(name="summary_forSort", index=Index.UN_TOKENIZED, store=Store.YES)})
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }
}

