/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.test.query.Author;

@Entity
@Indexed
public class Music {
    protected Long id;
    protected String title;
    protected Set<Author> authors = new HashSet<Author>();

    @Id
    @GeneratedValue
    @DocumentId
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=Author.class)
    @IndexedEmbedded(depth=1)
    public Set<Author> getAuthors() {
        return this.authors;
    }

    public void setAuthors(Set<Author> authors) {
        this.authors = authors;
    }

    public void addAuthor(Author author) {
        this.getAuthors().add(author);
    }

    @Column(name="title", length=255, nullable=false)
    @Field(name="title", index=Index.TOKENIZED, store=Store.YES)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

