/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.criteria;

import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.fest.assertions.BooleanAssert;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.query.criteria.Tractor;
import org.junit.Test;

public class ResultSizeOnCriteriaTest
extends SearchTestCase {
    @Test
    public void testResultSize() throws ParseException {
        this.indexTestData();
        Session session = this.openSession();
        Transaction tx = session.beginTransaction();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
        QueryBuilder qb = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Tractor.class).get();
        Query query = qb.keyword().wildcard().onField("owner").matching((Object)"p*").createQuery();
        Criteria criteria = session.createCriteria(Tractor.class);
        criteria.add((Criterion)Restrictions.eq((String)"hasColor", (Object)Boolean.FALSE));
        FullTextQuery hibQuery = fullTextSession.createFullTextQuery(query, new Class[]{Tractor.class}).setCriteriaQuery(criteria);
        List result = hibQuery.list();
        ResultSizeOnCriteriaTest.assertEquals((int)1, (int)result.size());
        for (Tractor tractor : result) {
            Assertions.assertThat((boolean)tractor.isHasColor()).isFalse();
            Assertions.assertThat((String)tractor.getOwner()).startsWith("P");
        }
        try {
            hibQuery.getResultSize();
            ((BooleanAssert)Assertions.assertThat((boolean)true).as("HSEARCH000105 should have been raised")).isFalse();
        }
        catch (SearchException e) {
            Assertions.assertThat((String)e.getMessage()).startsWith("HSEARCH000105");
        }
        Assertions.assertThat((List)result).hasSize(1);
        tx.commit();
        tx = session.beginTransaction();
        for (Object element : session.createQuery("select t from Tractor t").list()) {
            session.delete(element);
        }
        tx.commit();
        session.close();
    }

    private void indexTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Tractor tractor = new Tractor();
        tractor.setKurztext("tractor");
        tractor.setOwner("Paul");
        tractor.removeColor();
        s.persist((Object)tractor);
        Tractor tractor2 = new Tractor();
        tractor2.setKurztext("tractor");
        tractor2.setOwner("Pierre");
        s.persist((Object)tractor2);
        Tractor tractor3 = new Tractor();
        tractor3.setKurztext("tractor");
        tractor3.setOwner("Jacques");
        s.persist((Object)tractor3);
        tx.commit();
        s.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Tractor.class};
    }
}

