/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.facet;

import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.test.query.facet.AbstractFacetTest;
import org.hibernate.search.test.query.facet.Car;
import org.hibernate.search.test.query.facet.Fruit;

public class FacetFilteringTest
extends AbstractFacetTest {
    public void testDiscreteFacetDrillDown() throws Exception {
        String indexFieldName = "cubicCapacity";
        String facetName = "ccs";
        Query luceneQuery = this.queryBuilder(Car.class).keyword().onField("make").matching((Object)"Honda").createQuery();
        FacetingRequest request = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().createFacetingRequest();
        FullTextQuery query = this.fullTextSession.createFullTextQuery(luceneQuery, new Class[]{Car.class});
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(request);
        query.setFirstResult(0).setMaxResults(1);
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)13, (int)query.getResultSize());
        List facetList = facetManager.getFacets("ccs");
        this.assertFacetCounts(facetList, new int[]{5, 4, 4, 0});
        facetManager.getFacetGroup("ccs").selectFacets(new Facet[]{(Facet)facetList.get(0)});
        query.list();
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)5, (int)query.getResultSize());
        List newFacetList = facetManager.getFacets("ccs");
        this.assertFacetCounts(newFacetList, new int[]{5, 0, 0, 0});
        facetManager.getFacetGroup("ccs").selectFacets(new Facet[]{(Facet)facetList.get(1)});
        query.setMaxResults(Integer.MAX_VALUE);
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)9, (int)query.list().size());
        newFacetList = facetManager.getFacets("ccs");
        this.assertFacetCounts(newFacetList, new int[]{5, 4, 0, 0});
    }

    public void testMultipleFacetDrillDown() throws Exception {
        String ccsFacetName = "ccs";
        String ccsFacetFieldName = "cubicCapacity";
        FacetingRequest ccsFacetRequest = this.queryBuilder(Car.class).facet().name("ccs").onField("cubicCapacity").discrete().createFacetingRequest();
        String colorFacetName = "color";
        String colorFacetFieldName = "color";
        FacetingRequest colorFacetRequest = this.queryBuilder(Car.class).facet().name("color").onField("color").discrete().createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Car.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(colorFacetRequest);
        facetManager.enableFaceting(ccsFacetRequest);
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)50, (int)query.getResultSize());
        this.assertFacetCounts(facetManager.getFacets("color"), new int[]{12, 12, 12, 12, 2});
        this.assertFacetCounts(facetManager.getFacets("ccs"), new int[]{17, 16, 16, 1});
        Facet colorFacet = (Facet)facetManager.getFacets("color").get(0);
        facetManager.getFacetGroup("color").selectFacets(new Facet[]{colorFacet});
        this.assertFacetCounts(facetManager.getFacets("color"), new int[]{12, 0, 0, 0, 0});
        this.assertFacetCounts(facetManager.getFacets("ccs"), new int[]{4, 4, 4, 0});
        Facet ccsFacet = (Facet)facetManager.getFacets("ccs").get(0);
        facetManager.getFacetGroup("color").selectFacets(new Facet[]{colorFacet});
        facetManager.getFacetGroup("ccs").selectFacets(new Facet[]{ccsFacet});
        this.assertFacetCounts(facetManager.getFacets("color"), new int[]{4, 0, 0, 0, 0});
        this.assertFacetCounts(facetManager.getFacets("ccs"), new int[]{4, 0, 0, 0});
        facetManager.getFacetGroup("color").clearSelectedFacets();
        facetManager.getFacetGroup("ccs").clearSelectedFacets();
        this.assertFacetCounts(facetManager.getFacets("color"), new int[]{12, 12, 12, 12, 2});
        this.assertFacetCounts(facetManager.getFacets("ccs"), new int[]{17, 16, 16, 1});
    }

    public void testRangeFacetDrillDown() {
        String indexFieldName = "price";
        String priceRange = "priceRange";
        FacetingRequest rangeRequest = this.queryBuilder(Fruit.class).facet().name("priceRange").onField("price").range().from((Object)0.0).to((Object)1.0).from((Object)1.01).to((Object)1.5).from((Object)1.51).to((Object)3.0).from((Object)4.0).to((Object)5.0).createFacetingRequest();
        FullTextQuery query = this.createMatchAllQuery(Fruit.class);
        FacetManager facetManager = query.getFacetManager();
        facetManager.enableFaceting(rangeRequest);
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)10, (int)query.getResultSize());
        List facets = facetManager.getFacets("priceRange");
        this.assertFacetCounts(facets, new int[]{5, 3, 2, 0});
        facetManager.getFacetGroup("priceRange").selectFacets(new Facet[]{(Facet)facets.get(2)});
        FacetFilteringTest.assertEquals((String)"Wrong number of query matches", (int)2, (int)query.list().size());
        List newFacetList = facetManager.getFacets("priceRange");
        this.assertFacetCounts(newFacetList, new int[]{2, 0, 0, 0});
    }

    @Override
    public void loadTestData(Session session) {
        Transaction tx = session.beginTransaction();
        for (int i = 0; i < fruits.length; ++i) {
            Fruit fruit = new Fruit(fruits[i], fruitPrices[i]);
            session.save((Object)fruit);
        }
        for (String make : makes) {
            for (String color : colors) {
                for (int cc : ccs) {
                    Car car = new Car(make, color, cc);
                    session.save((Object)car);
                }
            }
        }
        Car car = new Car("Honda", "yellow", 2407);
        session.save((Object)car);
        car = new Car("Ford", "yellow", 2500);
        session.save((Object)car);
        tx.commit();
        session.clear();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Car.class, Fruit.class};
    }
}

