/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.nullValues;

import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.test.SearchTestCase;
import org.hibernate.search.test.query.ProjectionToMapResultTransformer;
import org.hibernate.search.test.query.nullValues.Value;
import org.hibernate.transform.ResultTransformer;

public class IndexAndQueryNullTest
extends SearchTestCase {
    public void testIndexAndSearchNull() throws Exception {
        Value fooValue = new Value("foo");
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.session.save((Object)fooValue);
        this.session.save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        this.searchKeywordWithExpectedNumberOfResults(fullTextSession, "foo", 1);
        this.searchKeywordWithExpectedNumberOfResults(fullTextSession, "_custom_token_", 1);
        tx.commit();
        fullTextSession.close();
    }

    public void testLuceneDocumentContainsNullToken() throws Exception {
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.session.save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        Document document = this.getSingleIndexedDocument(fullTextSession, QueryType.USE_LUCENE_QUERY);
        String indexedNullString = document.get("value");
        String expectedString = "_custom_token_";
        IndexAndQueryNullTest.assertEquals((String)("The null value should be indexed as " + expectedString), (String)expectedString, (String)indexedNullString);
        tx.commit();
        fullTextSession.close();
    }

    public void testNullIndexingWithDSLQuery() throws Exception {
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.session.save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        Document document = this.getSingleIndexedDocument(fullTextSession, QueryType.USE_DSL_QUERY);
        String indexedNullString = document.get("value");
        String expectedString = "_custom_token_";
        IndexAndQueryNullTest.assertEquals((String)("The null value should be indexed as " + expectedString), (String)expectedString, (String)indexedNullString);
        tx.commit();
        fullTextSession.close();
    }

    public void testNullIndexingWithDSLQueryIgnoringFieldBridge() throws Exception {
        try {
            QueryBuilder queryBuilder = this.getSearchFactory().buildQueryBuilder().forEntity(Value.class).get();
            ((TermMatchingContext)queryBuilder.keyword().onField("value").ignoreFieldBridge()).matching(null).createQuery();
            IndexAndQueryNullTest.fail();
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    public void testProjectedValueGetsConvertedToNull() throws Exception {
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.session.save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        Query query = this.createLuceneQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Value.class});
        fullTextQuery.setProjection(new String[]{"id", "value"});
        fullTextQuery.setResultTransformer((ResultTransformer)new ProjectionToMapResultTransformer());
        List mappedResults = fullTextQuery.list();
        IndexAndQueryNullTest.assertTrue((String)"Wrong result size", (mappedResults.size() == 1 ? 1 : 0) != 0);
        Map map = (Map)mappedResults.get(0);
        Integer id = (Integer)map.get("id");
        IndexAndQueryNullTest.assertNotNull((Object)id);
        String value = (String)map.get("value");
        IndexAndQueryNullTest.assertEquals((String)"The null token should be converted back to null", null, (String)value);
        tx.commit();
        fullTextSession.close();
    }

    public void testConfiguredDefaultNullToken() throws Exception {
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.session.save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        Document document = this.getSingleIndexedDocument(fullTextSession, QueryType.USE_LUCENE_QUERY);
        String indexedNullString = document.get("fallback");
        String expectedString = "fubar";
        IndexAndQueryNullTest.assertEquals((String)("The null value should be indexed as " + expectedString), (String)expectedString, (String)indexedNullString);
        tx.commit();
        fullTextSession.close();
    }

    public void testNullIndexingWithCustomFieldBridge() throws Exception {
        Value nullValue = new Value(null);
        FullTextSession fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = fullTextSession.beginTransaction();
        this.session.save((Object)nullValue);
        tx.commit();
        fullTextSession.clear();
        tx = fullTextSession.beginTransaction();
        Document document = this.getSingleIndexedDocument(fullTextSession, QueryType.USE_LUCENE_QUERY);
        String indexedNullString = document.get("dummy");
        String expectedString = "_dummy_";
        IndexAndQueryNullTest.assertEquals((String)("The null value should be indexed as " + expectedString), (String)expectedString, (String)indexedNullString);
        tx.commit();
        fullTextSession.close();
    }

    private Document getSingleIndexedDocument(FullTextSession fullTextSession, QueryType type) throws ParseException {
        Query query = QueryType.USE_LUCENE_QUERY.equals((Object)type) ? this.createLuceneQuery() : this.createDSLQuery();
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(query, new Class[]{Value.class});
        fullTextQuery.setProjection(new String[]{"__HSearch_Document"});
        fullTextQuery.setResultTransformer((ResultTransformer)new ProjectionToMapResultTransformer());
        List mappedResults = fullTextQuery.list();
        IndexAndQueryNullTest.assertTrue((String)"Wrong result size", (mappedResults.size() == 1 ? 1 : 0) != 0);
        Map map = (Map)mappedResults.get(0);
        Document document = (Document)map.get("__HSearch_Document");
        IndexAndQueryNullTest.assertNotNull((Object)document);
        return document;
    }

    private Query createLuceneQuery() throws ParseException {
        QueryParser parser = new QueryParser(IndexAndQueryNullTest.getTargetLuceneVersion(), "id", SearchTestCase.standardAnalyzer);
        parser.setAllowLeadingWildcard(true);
        return parser.parse("*");
    }

    private Query createDSLQuery() {
        QueryBuilder queryBuilder = this.getSearchFactory().buildQueryBuilder().forEntity(Value.class).get();
        return queryBuilder.keyword().onField("value").matching(null).createQuery();
    }

    private void searchKeywordWithExpectedNumberOfResults(FullTextSession fullTextSession, String queryString, int expectedNumberOfResults) throws Exception {
        TermQuery query = new TermQuery(new Term("value", queryString));
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)query, new Class[]{Value.class});
        List valueList = fullTextQuery.list();
        IndexAndQueryNullTest.assertEquals((String)"Wrong number of results", (int)expectedNumberOfResults, (int)valueList.size());
    }

    @Override
    protected void configure(Configuration cfg) {
        super.configure(cfg);
        cfg.setProperty("hibernate.search.default_null_token", "fubar");
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Value.class};
    }

    static enum QueryType {
        USE_LUCENE_QUERY,
        USE_DSL_QUERY;

    }
}

