/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.timeout;

import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.QueryTimeoutException;
import org.apache.lucene.search.Query;
import org.hibernate.search.jpa.FullTextEntityManager;
import org.hibernate.search.jpa.FullTextQuery;
import org.hibernate.search.jpa.Search;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.jpa.JPATestCase;
import org.hibernate.search.test.query.timeout.Clock;

public class JPATimeoutTest
extends JPATestCase {
    public void testQueryTimeoutException() throws Exception {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        for (int i = 0; i < 1000; ++i) {
            Clock clock = new Clock("Model cat A" + i, i % 2 == 0 ? "Seiko" : "Swatch", new Long(2000 + i));
            em.persist((Object)clock);
        }
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query query = builder.keyword().onField("brand").matching((Object)"Seiko").createQuery();
        FullTextQuery hibernateQuery = em.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.setHint("javax.persistence.query.timeout", (Object)1);
        try {
            hibernateQuery.getResultSize();
            JPATimeoutTest.fail((String)"timeout exception should happen");
        }
        catch (QueryTimeoutException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            JPATimeoutTest.fail((String)"Expected a QueryTimeoutException");
        }
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        JPATimeoutTest.assertEquals((int)1000, (int)em.createQuery("delete from " + Clock.class.getName()).executeUpdate());
        em.getTransaction().commit();
        em.close();
    }

    public void testLimitFetchingTime() {
        FullTextEntityManager em = Search.getFullTextEntityManager((EntityManager)this.factory.createEntityManager());
        em.getTransaction().begin();
        for (int i = 0; i < 1000; ++i) {
            Clock clock = new Clock("Model cat A" + i, i % 2 == 0 ? "Seiko" : "Swatch", new Long(2000 + i));
            em.persist((Object)clock);
        }
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        QueryBuilder builder = em.getSearchFactory().buildQueryBuilder().forEntity(Clock.class).get();
        Query query = builder.keyword().onField("brand").matching((Object)"Seiko").createQuery();
        FullTextQuery hibernateQuery = em.createFullTextQuery(query, new Class[]{Clock.class});
        List results = hibernateQuery.getResultList();
        JPATimeoutTest.assertEquals((int)500, (int)results.size());
        em.clear();
        query = builder.keyword().onField("brand").matching((Object)"Swatch").createQuery();
        hibernateQuery = em.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.limitExecutionTimeTo(1L, TimeUnit.NANOSECONDS);
        List result = hibernateQuery.getResultList();
        System.out.println("Result size early: " + result.size());
        JPATimeoutTest.assertEquals((String)"Test early failure, before the number of results are even fetched", (int)0, (int)result.size());
        if (result.size() == 0) {
            JPATimeoutTest.assertTrue((boolean)hibernateQuery.hasPartialResults());
        }
        em.clear();
        hibernateQuery = em.createFullTextQuery(query, new Class[]{Clock.class});
        hibernateQuery.limitExecutionTimeTo(30L, TimeUnit.SECONDS);
        results = hibernateQuery.getResultList();
        JPATimeoutTest.assertEquals((String)"Test below limit termination", (int)500, (int)results.size());
        JPATimeoutTest.assertFalse((boolean)hibernateQuery.hasPartialResults());
        em.getTransaction().commit();
        em.clear();
        em.getTransaction().begin();
        JPATimeoutTest.assertEquals((int)1000, (int)em.createQuery("delete from " + Clock.class.getName()).executeUpdate());
        em.getTransaction().commit();
        em.close();
    }

    @Override
    public Class[] getAnnotatedClasses() {
        return new Class[]{Clock.class};
    }
}

